/*
 * Decompiled with CFR 0.152.
 */
package zigen.sql.parser;

import zigen.sql.parser.INode;
import zigen.sql.parser.IVisitor;
import zigen.sql.parser.ast.ASTAlias;
import zigen.sql.parser.ast.ASTCaseCause;
import zigen.sql.parser.ast.ASTExpression;
import zigen.sql.parser.ast.ASTFunction;
import zigen.sql.parser.ast.ASTInnerAlias;
import zigen.sql.parser.ast.ASTOperator;
import zigen.sql.parser.ast.ASTOutfile;
import zigen.sql.parser.ast.ASTParentheses;
import zigen.sql.parser.ast.ASTRoot;
import zigen.sql.parser.ast.ASTSelectStatement;
import zigen.sql.parser.ast.ASTTable;

public class ASTVisitorToString
implements IVisitor {
    StringBuffer sb = new StringBuffer();
    boolean isShowAs = false;

    public ASTVisitorToString() {
    }

    public ASTVisitorToString(boolean isShowAs) {
        this.isShowAs = isShowAs;
    }

    public INode findNode(int offset) {
        throw new UnsupportedOperationException("UnSupported Method");
    }

    public int getIndex() {
        throw new UnsupportedOperationException("UnSupported Method");
    }

    private void setAliasName(ASTAlias target) {
        if (target.hasAlias()) {
            if (this.isShowAs) {
                this.sb.append("AS ");
            }
            this.sb.append(String.valueOf(target.getAliasName()) + " ");
        }
    }

    public Object visit(INode node, Object data) {
        if (node instanceof ASTRoot || node instanceof ASTSelectStatement || node instanceof ASTInnerAlias || node instanceof ASTExpression) {
            node.childrenAccept(this, data);
        } else if (node instanceof ASTTable) {
            ASTTable table = (ASTTable)node;
            this.sb.append(String.valueOf(table.getName()) + " ");
            this.setAliasName(table);
            node.childrenAccept(this, data);
        } else if (node instanceof ASTFunction) {
            ASTFunction function = (ASTFunction)node;
            this.sb.append(String.valueOf(function.getName()));
            node.childrenAccept(this, data);
            this.setAliasName(function);
        } else if (node instanceof ASTParentheses) {
            ASTParentheses p = (ASTParentheses)node;
            this.sb.append("(");
            node.childrenAccept(this, data);
            this.sb.deleteCharAt(this.sb.toString().length() - 1);
            this.sb.append(") ");
            this.setAliasName(p);
        } else if (node instanceof ASTOperator) {
            ASTOperator ope = (ASTOperator)node;
            if (ope.hasRightChild()) {
                node.getChild(0).accept(this, null);
                this.sb.append(String.valueOf(node.getName()) + " ");
                node.getChild(1).accept(this, null);
            } else if (ope.hasLeftChild()) {
                node.getChild(0).accept(this, null);
                this.sb.append(String.valueOf(node.getName()) + " ");
            } else {
                this.sb.append(String.valueOf(node.getName()) + " ");
                node.childrenAccept(this, data);
            }
        } else if (node instanceof ASTCaseCause) {
            ASTCaseCause cc = (ASTCaseCause)node;
            node.childrenAccept(this, data);
            this.sb.deleteCharAt(this.sb.toString().length() - 1);
            if (cc.isComplete()) {
                this.sb.append(" end ");
            }
            this.setAliasName(cc);
        } else if (node instanceof ASTOutfile) {
            ASTOutfile outfile = (ASTOutfile)node;
            this.sb.append(String.valueOf(node.getName()) + " ");
            this.sb.append(outfile.getFilePath());
            this.sb.append(" ");
        } else {
            this.sb.append(String.valueOf(node.getName()) + " ");
            node.childrenAccept(this, data);
        }
        return data;
    }

    public String toString() {
        return this.sb.toString();
    }

    public void print() {
        System.out.println(this.sb.toString());
    }
}

