/*
 * Decompiled with CFR 0.152.
 */
package zigen.sql.parser.ast;

import zigen.sql.parser.ASTVisitor;
import zigen.sql.parser.ast.ASTAlias;

public class ASTTable
extends ASTAlias {
    private String schemaName;
    private String tableName;

    public ASTTable(String tableName, int offset, int length, int scope) {
        super(tableName, offset, length, scope);
        this.parse(tableName);
    }

    private void parse(String tableName) {
        String[] strs = tableName.split("[.]");
        if (strs.length == 2) {
            this.schemaName = strs[0];
            this.tableName = strs[1];
        } else if (strs.length == 1) {
            this.tableName = strs[0];
        }
    }

    public String getName() {
        StringBuffer sb = new StringBuffer();
        if (this.schemaName != null) {
            sb.append(this.schemaName);
            sb.append(".");
        }
        if (this.tableName != null) {
            sb.append(this.tableName);
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        if (this.hasAlias()) {
            sb.append(" AS ");
            sb.append(this.getAliasName());
        }
        return String.valueOf(this.getNodeClassName()) + " text=\"" + sb.toString() + "\"";
    }

    public Object accept(ASTVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getAliasName() {
        if (this.hasAlias()) {
            return super.getAliasName();
        }
        return this.tableName;
    }
}

