/*
 * 作成日: 2008/08/05
 * 著作権: Copyright (c) 2005 ZIGEN
 * ライセンス：Eclipse Public License - v 1.0
 * 原文：http://www.eclipse.org/legal/epl-v10.html
 */
package zigen.plugin.db.ext.s2jdbc.ui;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

import zigen.plugin.db.ext.s2jdbc.Activator;

public class PackageSelectDialog extends TitleAreaDialog {

    private TreeViewer viewer;

    private PackageFragment packageFragment;

    private String title;

    private String message;

    public PackageSelectDialog(Shell parentShell, String title, String message) {
        super(parentShell);
        this.title = title;
        parentShell.setText(title);

        this.message = message;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(title); // ダイアログウィンドウのタイトル
    }

    /*
     * (非 Javadoc)
     * 
     * @see
     * org.eclipse.jface.dialogs.Dialog#createDialogArea(org.eclipse.swt.widgets
     * .Composite)
     */
    protected Control createDialogArea(Composite parent) {
        // タイトルの設定
        super.setTitle(title);
        super.setMessage(message);

        Composite composite = (Composite) super.createDialogArea(parent);

        // // パスを表示するためのテキストボックス
        // text = new Text(composite, SWT.BORDER);
        // text.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        // text.setEditable(false);

        Composite composite2 = new Composite(composite, SWT.NONE);
        composite2.setLayoutData(new GridData(GridData.FILL_BOTH));

        FillLayout layout = new FillLayout();
        composite2.setLayout(layout);

        // ツリーの作成
        viewer = new TreeViewer(composite2, SWT.BORDER);

        // Javaプロジェクト表示の設定
        viewer.setContentProvider(new StandardJavaElementContentProvider());
        // viewer.setContentProvider(new JavaNavigatorContentProvider());
        viewer.setSorter(new JavaProjectSorter());

        // フィルタの設定
        viewer.addFilter(new SourceDirViewerFilter());

        // ラベルプロバイダーの設定
        JavaElementLabelProvider provider = new JavaElementLabelProvider();
        viewer.setLabelProvider(provider);

        // Javaモデルの設定
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IJavaModel javaModel = JavaCore.create(root);
        viewer.setInput(javaModel);

        // デフォルトプロジェクトが指定されている場合は、展開しておく
        String defaultProject = Activator.getDefault().getDefaultProject();
        if (defaultProject != null)
            expandDefaultProject(javaModel, defaultProject);

        // ツリーを選択したときの処理
        viewer.addSelectionChangedListener(new ISelectionChangedListener() {

            public void selectionChanged(SelectionChangedEvent event) {
                selectionChangeHandler(event);
            }
        });

        return composite;
    }

    private void expandDefaultProject(IJavaModel javaModel, String defaultProject) {
        IJavaProject jProject = javaModel.getJavaProject(defaultProject);

        if (jProject != null && jProject.exists()) {
            IJavaProject myJavaProject = javaModel.getJavaProject(defaultProject);
            viewer.expandToLevel(myJavaProject, 2);

        }
    }

    /*
     * (非 Javadoc)
     * 
     * @see
     * org.eclipse.jface.window.Window#createContents(org.eclipse.swt.widgets
     * .Composite)
     */
    protected Control createContents(Composite parent) {
        Control ctl = super.createContents(parent);
        // OKボタンを使用不可にする
        getButton(IDialogConstants.OK_ID).setEnabled(false);
        return ctl;
    }

    private void selectionChangeHandler(SelectionChangedEvent event) {
        // 選択したものによって表示するメニューを変更
        Object obj = (Object) ((StructuredSelection) event.getSelection()).getFirstElement();

        if (obj instanceof PackageFragment) {
            packageFragment = (PackageFragment) obj;
            getButton(IDialogConstants.OK_ID).setEnabled(true);

        } else {
            packageFragment = null;
            getButton(IDialogConstants.OK_ID).setEnabled(false);
        }

    }

    /**
     * ダイアログサイズ
     */
    protected Point getInitialSize() {
        return new Point(480, 450);
    }

    /**
     * 選択されたパッケージ(PackageFragment)の取得
     * 
     * @return
     */
    public PackageFragment getPackageFragment() {
        return packageFragment;
    }
}
