package zigen.plugin.db.ext.jdt.ui;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

import zigen.plugin.db.ext.jdt.Activator;
import zigen.plugin.db.ext.jdt.ui.Messages;

public class GeneratePreferencePage extends FieldEditorPreferencePage implements IWorkbenchPreferencePage {

	public static final String DESC = Messages.getString("GeneratePreferencePage.0"); //$NON-NLS-1$

	public static final String P_GENERATE_INFO_ON = "GeneratePreferencePage.GenerateInfoOn"; //$NON-NLS-1$

	public static final String P_CLASS_COMMENT_ON = "GeneratePreferencePage.ClassCommentOn"; //$NON-NLS-1$

	public static final String P_UNDER_LINE_CUT = "GeneratePreferencePage.UnderLineCut"; //$NON-NLS-1$

	public static final String P_ACCESS_MODIFIERS = "GeneratePreferencePage.AccessModifiers"; //$NON-NLS-1$

	public void init(IWorkbench workbench) {
	}

	public GeneratePreferencePage() {
		super(GRID);
		super.setPreferenceStore(Activator.getDefault().getPreferenceStore());
		super.setDescription(DESC);
	}

	public void createFieldEditors() {
		String[][] labelAndValue = new String[][] {
				new String[] {
						"private(&V)", "private" //$NON-NLS-1$ //$NON-NLS-2$
				},
				new String[] {
						"default(&D)", "" //$NON-NLS-1$ //$NON-NLS-2$
				},
				new String[] {
						"protected(&T)", "protected" //$NON-NLS-1$ //$NON-NLS-2$
				},
		};

		addField(new BooleanFieldEditor(P_GENERATE_INFO_ON, Messages.getString("GeneratePreferencePage.11"), getFieldEditorParent())); //$NON-NLS-1$
		addField(new BooleanFieldEditor(P_CLASS_COMMENT_ON, Messages.getString("GeneratePreferencePage.12"), getFieldEditorParent())); //$NON-NLS-1$
		addField(new BooleanFieldEditor(P_UNDER_LINE_CUT, Messages.getString("GeneratePreferencePage.13"), getFieldEditorParent())); //$NON-NLS-1$
		addField(new RadioGroupFieldEditor(P_ACCESS_MODIFIERS, Messages.getString("GeneratePreferencePage.14"), labelAndValue.length, labelAndValue, getFieldEditorParent())); //$NON-NLS-1$

	}

}