/*
 * Decompiled with CFR 0.152.
 */
package zigen.sql.parser.ast;

import zigen.sql.parser.INode;
import zigen.sql.parser.Node;
import zigen.sql.parser.ast.ASTInnerAlias;
import zigen.sql.parser.exception.ExistAliasNameException;

public abstract class ASTAlias
extends Node {
    protected boolean alias;
    protected INode aliasNode;
    protected boolean updatableAliasName = true;

    public ASTAlias(String id, int offset, int length, int scope) {
        super(id, offset, length, scope);
    }

    public String getAliasName() {
        return this.aliasNode == null ? null : this.aliasNode.getName();
    }

    public void setAliasName(String aliasName, int offset, int length) {
        if (this.hasAlias()) {
            throw new ExistAliasNameException(aliasName, offset, length);
        }
        if (this.updatableAliasName) {
            this.aliasNode = new ASTInnerAlias(aliasName, offset, length, this.scope);
            this.addChild(this.aliasNode);
        }
        this.alias = true;
    }

    public boolean hasAlias() {
        return this.alias;
    }

    public boolean isUpdatableAliasName() {
        return this.updatableAliasName;
    }

    public void setUpdatableAliasName(boolean updatable) {
        this.updatableAliasName = updatable;
    }

    public int getAliasLength() {
        return this.aliasNode == null ? 0 : this.aliasNode.getLength();
    }

    public int getAliasOffset() {
        return this.aliasNode == null ? 0 : this.aliasNode.getOffset();
    }
}

