/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package jp.sourceforge.damstation_dl.data;

import java.text.ParseException;
import junit.framework.Assert;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

/**
 *
 * @author d
 */
public class ResultDateTest {

    public ResultDateTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    /**
     * Test of getInstance method, of class ResultDate.
     */
    @Test
    public void testGetInstance() {
        {
            System.out.println("getInstance:nullチェック");
            try {
                ResultDate date = ResultDate.getInstance(null);
                Assert.fail("例外発生せず");
            } catch(NullPointerException e) {
                // 成功
            } catch(Exception e) {
                Assert.fail("例外発生\n\te=" + e);
            }
        }
        
        {
            System.out.println("getInstance:妥当でないdateのときのチェック");
            try {
                ResultDate date = ResultDate.getInstance("");
                Assert.fail("例外発生せず");
            } catch(IllegalArgumentException e) {
                // 成功
            } catch(Exception e) {
                Assert.fail("例外発生\n\te=" + e);
            }
        }
        
        {
            System.out.println("getInstance:同じdateのインスタンスチェック");
            try {
                ResultDate date1 = ResultDate.getInstance("2008-09-16T11:22:33");
                ResultDate date2 = ResultDate.getInstance("2008-09-16T11:22:33");
                Assert.assertTrue("インスタンスの不一致", date1 == date2);
            } catch(Exception e) {
                Assert.fail("例外発生\n\te=" + e);
            }
        }
    }

    /**
     * Test of isValid method, of class ResultDate.
     */
    @Test
    public void testIsValid() {
        {
            System.out.println("isValid:nullチェック");
            try {
                boolean result = ResultDate.isValid(null);
                Assert.fail("例外発生せず");
            } catch(NullPointerException e) {
                // 成功
            } catch(Exception e) {
                Assert.fail("例外発生\n\te=" + e);
            }
        }
        
        {
            System.out.println("isValid:文字数チェック");
            try {
                boolean result0 = ResultDate.isValid("2002-09-16T11:2:3");
                boolean result1 = ResultDate.isValid("2002-09-16T11:22:3");
                boolean result2 = ResultDate.isValid("2002-09-16T11:22:33");
                boolean result3 = ResultDate.isValid("2002-09-16T11:22:333");
                Assert.assertTrue("17文字で成功", !result0);
                Assert.assertTrue("18文字で成功", !result1);
                Assert.assertTrue("20文字で成功", !result3);
                Assert.assertTrue("19文字で失敗", result2);
            } catch(Exception e) {
                Assert.fail("例外発生\n\te=" + e);
            }
        }
        
        {
            System.out.println("isValid:内容チェック");
            try {
                boolean result1 = ResultDate.isValid("2002-09-16T11:222:3");
                boolean result2 = ResultDate.isValid("2002-09-16 11:22:33");
                boolean result3 = ResultDate.isValid("2002/09/16T11:22:33");
                boolean result4 = ResultDate.isValid("2002-09-16T11:60:33");
                Assert.assertTrue("分が3桁で成功", !result1);
                Assert.assertTrue("Tがない時に成功", !result2);
                Assert.assertTrue("日付の区切りが/で成功", !result3);
                Assert.assertTrue("60分で成功", !result4);
            } catch(Exception e) {
                Assert.fail("例外発生\n\te=" + e);
            }
        }
    }

    /**
     * Test of damStationDateToXmlDateTime method, of class ResultDate.
     */
    @Test
    public void testDamStationDateToXmlDateTime() throws Exception {
        {
            System.out.println("damStationDateToXmlDateTime:nullチェック");
            try {
                String dateString = ResultDate.damStationDateToXmlDateTime(null);
                Assert.fail("例外発生せず");
            } catch(NullPointerException e) {
                // 成功
            } catch(Exception e) {
                Assert.fail("例外発生\n\te=" + e);
            }
        }
        
        {
            System.out.println("damStationDateToXmlDateTime:日時と時刻の間のスペースなしチェック");
            try {
                String dateString = ResultDate.damStationDateToXmlDateTime("2008/01/0111:22:33");
                Assert.fail("例外発生せず");
            } catch(ParseException e) {
                // 成功
            } catch(Exception e) {
                Assert.fail("例外発生\n\te=" + e);
            }
        }
        
        {
            System.out.println("damStationDateToXmlDateTime:日時の区切りが-のときのチェック");
            try {
                String dateString = ResultDate.damStationDateToXmlDateTime("2008-01-01 11:22:33");
                Assert.fail("例外発生せず");
            } catch(ParseException e) {
                // 成功
            } catch(Exception e) {
                Assert.fail("例外発生\n\te=" + e);
            }
        }
        
        {
            System.out.println("damStationDateToXmlDateTime:時刻の区切りが/のときのチェック");
            try {
                String dateString = ResultDate.damStationDateToXmlDateTime("2008/01/01 11/22/33");
                Assert.fail("例外発生せず");
            } catch(ParseException e) {
                // 成功
            } catch(Exception e) {
                Assert.fail("例外発生\n\te=" + e);
            }
        }
        
        {
            System.out.println("damStationDateToXmlDateTime:秒が無いのときのチェック");
            try {
                String dateString = ResultDate.damStationDateToXmlDateTime("2008/01/01 11:22:");
                Assert.fail("例外発生せず");
            } catch(ParseException e) {
                // 成功
            } catch(Exception e) {
                Assert.fail("例外発生\n\te=" + e);
            }
        }
        
        {
            System.out.println("damStationDateToXmlDateTime:成功パターンチェック");
            try {
                String dateString = ResultDate.damStationDateToXmlDateTime("2008/01/01 11:22:33");
                boolean result = "2008-01-01T11:22:33".equals(dateString);
                Assert.assertTrue("予期した変換ができていない\n\tdateString=" + dateString, result);
            } catch(Exception e) {
                Assert.fail("例外発生\n\te=" + e);
            }
        }
        
        {
            System.out.println("damStationDateToXmlDateTime:成功パターンチェック");
            try {
                String dateString = ResultDate.damStationDateToXmlDateTime("2008/08/26 18:22:34");
                boolean result = "2008-08-26T18:22:34".equals(dateString);
                Assert.assertTrue("予期した変換ができていない\n\tdateString=" + dateString, result);
            } catch(Exception e) {
                Assert.fail("例外発生\n\te=" + e);
            }
        }
    }

    /**
     * Test of getValue method, of class ResultDate.
     */
    @Test
    public void testGetValue() {
        {
            System.out.println("getValue:取得した文字列のチェック");
            ResultDate date = ResultDate.getInstance("2008-09-16T11:22:33");
            boolean result = "2008-09-16T11:22:33".equals(date.getValue());
            Assert.assertTrue("不一致\n\tdate.toString()=" + date.toString(), result);
        }
    }

}