/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package jp.sourceforge.damstation_dl.data;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

/**
 * パスワードの暗号化・復号化用クラス
 * @author d
 */
public class PasswordUtility {
    private static final String baseKey = "鍵の元";
    private static final Cipher encryptCipher;
    private static final Cipher decryptCipher;
    private static final BASE64Encoder base64Encoder;
    private static final BASE64Decoder base64Decoder;
    
    static {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] key = md.digest(baseKey.getBytes("UTF-8"));
            SecretKey secretKey = new SecretKeySpec(key, "AES");
        
            encryptCipher = Cipher.getInstance("AES");
            encryptCipher.init(Cipher.ENCRYPT_MODE, secretKey);
        
            decryptCipher = Cipher.getInstance("AES");
            decryptCipher.init(Cipher.DECRYPT_MODE, secretKey);
        
            base64Encoder = new BASE64Encoder();
            base64Decoder = new BASE64Decoder();
        } catch(InvalidKeyException e) {
            throw new IllegalStateException("PasswordUtility:初期化に失敗\n\te=" + e);
        } catch(NoSuchAlgorithmException e) {
            throw new IllegalStateException("PasswordUtility:初期化に失敗\n\te=" + e);
        } catch(NoSuchPaddingException e) {
            throw new IllegalStateException("PasswordUtility:初期化に失敗\n\te=" + e);
        } catch(UnsupportedEncodingException e) {
            throw new IllegalStateException("PasswordUtility:初期化に失敗\n\te=" + e);
        }
    }
    
    /**
     * AES暗号化→Base64エンコード
     * @param baseString エンコードする文字列
     * @return エンコード結果
     */
    public static String encode(String baseString) {
        if(baseString == null) {
            throw new NullPointerException("PasswordUtility.encode\n\tbaseString: " + baseString);
        }
        
        try {
            return new String(base64Encoder.encode(encryptCipher.doFinal(baseString.getBytes("UTF-8"))));
        } catch (BadPaddingException e) {
            throw new IllegalStateException(e);
        } catch (IllegalBlockSizeException e) {
            throw new IllegalStateException(e);
        } catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }
    
    /**
     * Base64デコード→AES復号
     * @param encodedString エンコードされた文字列
     * @return デコード結果
     */
    public static String decode(String encodedString) {
        if(encodedString == null) {
            throw new NullPointerException("PasswordUtility.decode\n\tencodedString: " + encodedString);
        }
        
        try {
            return new String(decryptCipher.doFinal(base64Decoder.decodeBuffer(encodedString)), "UTF-8");
        } catch (BadPaddingException e) {
            throw new IllegalStateException(e);
        } catch (IllegalBlockSizeException e) {
            throw new IllegalStateException(e);
        } catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        } catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}
