/*
 * MainWindow.java
 *
 * Created on 2008/08/15, 4:06
 */

package jp.sourceforge.damstation_dl;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import javax.swing.UIManager;
import jp.sourceforge.damstation_dl.data.ConfigData;
import jp.sourceforge.damstation_dl.data.PasswordUtility;
import jp.sourceforge.damstation_dl.data.ResultData2List;
import jp.sourceforge.damstation_dl.data.ResultDataList;
import jp.sourceforge.damstation_dl.data.SongDataList;

/**
 *
 * @author  d
 */
public class MainWindow extends javax.swing.JFrame {
    
    private final ConfigData configData;
    private final SongDataList songData;
    private final ResultDataList resultData;
    private final ResultData2List resultData2;
    private DownloadThread thread = null;
    
    /** Creates new form MainWindow */
    public MainWindow() {
        initComponents();
        
        // クッキーの設定
        CookieManager cookieManager = new CookieManager();
        cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL); // ALLじゃないと動かない…
        CookieHandler.setDefault(cookieManager);
        
        // 各種データの初期化
        this.configData = new ConfigData(GlobalData.CONFIG_FILE_IN);
        this.songData = new SongDataList(GlobalData.SONG_FILE_IN);
        this.resultData = new ResultDataList(GlobalData.RESULT_FILE_IN);
        this.resultData2 = new ResultData2List(GlobalData.RESULT2_FILE_IN);
                
        this.setFieldValue();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jScrollPane1 = new javax.swing.JScrollPane();
        jTextArea = new javax.swing.JTextArea();
        jTodoPanel = new javax.swing.JPanel();
        jTodoSeimitsuCheckBox = new javax.swing.JCheckBox();
        jTodoSeimitsu2CheckBox = new javax.swing.JCheckBox();
        jTodoFixSongDataCheckBox = new javax.swing.JCheckBox();
        jConfigPanel = new javax.swing.JPanel();
        jStartButton = new javax.swing.JButton();
        jStopButton = new javax.swing.JButton();
        jCardNumberLabel = new javax.swing.JLabel();
        jPasswordLabel = new javax.swing.JLabel();
        jCardNumberField = new javax.swing.JTextField();
        jPasswordField = new javax.swing.JPasswordField();

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        setTitle("DAMステーションダウンローダ ver0.6.3");
        setResizable(false);

        jTextArea.setColumns(20);
        jTextArea.setRows(5);
        jTextArea.setBorder(null);
        jTextArea.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jScrollPane1.setViewportView(jTextArea);

        jTodoPanel.setBackground(new java.awt.Color(255, 255, 255));
        jTodoPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("TODO"));

        jTodoSeimitsuCheckBox.setBackground(java.awt.Color.white);
        jTodoSeimitsuCheckBox.setText("精密採点");
        jTodoSeimitsuCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTodoSeimitsuCheckBoxActionPerformed(evt);
            }
        });

        jTodoSeimitsu2CheckBox.setBackground(java.awt.Color.white);
        jTodoSeimitsu2CheckBox.setText("精密採点II");

        jTodoFixSongDataCheckBox.setBackground(java.awt.Color.gray);
        jTodoFixSongDataCheckBox.setText("曲データ修正");
        jTodoFixSongDataCheckBox.setEnabled(false);

        javax.swing.GroupLayout jTodoPanelLayout = new javax.swing.GroupLayout(jTodoPanel);
        jTodoPanel.setLayout(jTodoPanelLayout);
        jTodoPanelLayout.setHorizontalGroup(
            jTodoPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jTodoPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jTodoPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jTodoSeimitsuCheckBox)
                    .addComponent(jTodoSeimitsu2CheckBox)
                    .addComponent(jTodoFixSongDataCheckBox))
                .addContainerGap(46, Short.MAX_VALUE))
        );
        jTodoPanelLayout.setVerticalGroup(
            jTodoPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jTodoPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jTodoSeimitsuCheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jTodoSeimitsu2CheckBox)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jTodoFixSongDataCheckBox)
                .addContainerGap(28, Short.MAX_VALUE))
        );

        jConfigPanel.setBackground(new java.awt.Color(255, 255, 255));
        jConfigPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("設定"));

        jStartButton.setText("開始");
        jStartButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jStartButtonActionPerformed(evt);
            }
        });

        jStopButton.setText("中止");
        jStopButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jStopButtonActionPerformed(evt);
            }
        });

        jCardNumberLabel.setText("カード番号");

        jPasswordLabel.setText("パスワード");

        jCardNumberField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCardNumberFieldActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jConfigPanelLayout = new javax.swing.GroupLayout(jConfigPanel);
        jConfigPanel.setLayout(jConfigPanelLayout);
        jConfigPanelLayout.setHorizontalGroup(
            jConfigPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jConfigPanelLayout.createSequentialGroup()
                .addGroup(jConfigPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jConfigPanelLayout.createSequentialGroup()
                        .addGap(44, 44, 44)
                        .addComponent(jStartButton)
                        .addGap(40, 40, 40)
                        .addComponent(jStopButton))
                    .addGroup(jConfigPanelLayout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(jConfigPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                            .addComponent(jCardNumberLabel, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jPasswordLabel, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 54, Short.MAX_VALUE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jConfigPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(jCardNumberField)
                            .addComponent(jPasswordField, javax.swing.GroupLayout.DEFAULT_SIZE, 162, Short.MAX_VALUE))))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        jConfigPanelLayout.setVerticalGroup(
            jConfigPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jConfigPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jConfigPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jCardNumberLabel)
                    .addComponent(jCardNumberField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jConfigPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jPasswordField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jPasswordLabel))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jConfigPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jStartButton)
                    .addComponent(jStopButton))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 430, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jConfigPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, 18)
                        .addComponent(jTodoPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jTodoPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jConfigPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 193, Short.MAX_VALUE)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
     * 開始ボタンを押した時の動作
     * @param evt
     */
private void jStartButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jStartButtonActionPerformed
    // SwingWorkerが実行中でない時は処理を開始させる
    if((this.thread == null) || this.thread.isDone()) {
        // カード番号とパスワード取得
        this.getFieldValue();
        
        // TODOの状態を取得
        TodoData todoData = new TodoData(
                this.jTodoSeimitsuCheckBox.isSelected(),
                this.jTodoSeimitsu2CheckBox.isSelected()
                );
        
        // SwingWorker動作開始
        this.thread = new DownloadThread(
                this.jStartButton,
                this.jTextArea,
                this.configData,
                this.songData,
                this.resultData,
                this.resultData2,
                todoData
                );
        this.thread.execute();
    }
}//GEN-LAST:event_jStartButtonActionPerformed

    /**
     * 中止ボタンを押した時の動作
     * @param evt
     */
private void jStopButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jStopButtonActionPerformed
    // SwingWorkerが実行中の時は中止させる
    if((this.thread != null) && !this.thread.isDone()) {
        //  中止
        this.thread.cancel(true);
    }
}//GEN-LAST:event_jStopButtonActionPerformed

private void jCardNumberFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCardNumberFieldActionPerformed
// TODO add your handling code here:
}//GEN-LAST:event_jCardNumberFieldActionPerformed

private void jTodoSeimitsuCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTodoSeimitsuCheckBoxActionPerformed
// TODO add your handling code here:
}//GEN-LAST:event_jTodoSeimitsuCheckBoxActionPerformed

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        // 見た目をWindowsっぽく変更
        try {
            UIManager.setLookAndFeel(GlobalData.lookAndFeel);
        } catch (Exception e) {
            e.printStackTrace();
            return;
        }

        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                MainWindow frame = new MainWindow();
                frame.init();
                frame.setVisible(true);
            }
        });
    }
    
    private void init() {
        this.addWindowListener(new WindowAdapter() {

            @Override
            public void windowClosing(WindowEvent event) {
                // 動作中は終了をキャンセル
                if ((thread != null) && !thread.isDone()) {
                    return;
                }
                
                // 設定ファイルを書き込む
                synchronized (configData) {
                    getFieldValue();
                    if (configData != null) {
                        try {
                            configData.writeXml(GlobalData.CONFIG_FILE_OUT);
                        } catch (IOException e) {
                        }
                    }
                }
                
                // 曲データファイルを書き込む
                synchronized (songData) {
                    if (songData != null) {
                        try {
                            songData.writeXml(GlobalData.SONG_FILE_OUT);
                        } catch (IOException e) {
                        }
                    }
                }
                
                // 精密採点の結果データファイルを書き込む
                synchronized (resultData) {
                    if (resultData != null) {
                        try {
                            resultData.writeXml(GlobalData.RESULT_FILE_OUT);
                        } catch (IOException e) {
                        }
                    }
                }
                
                // 精密採点IIの結果データファイルを書き込む
                synchronized (resultData2) {
                    if (resultData2 != null) {
                        try {
                            resultData2.writeXml(GlobalData.RESULT2_FILE_OUT);
                        } catch (IOException e) {
                        }
                    }
                }
                
                // 終了する
                dispose();
            }
        });
    }
    
    /**
     * カード番号とパスワードをフォームにセットする
     */
    private void setFieldValue() {
        this.jCardNumberField.setText(this.configData.getCardNumber());
        this.jPasswordField.setText(PasswordUtility.decode(this.configData.getPassword()));
    }
    
    /**
     * カード番号とパスワードをフォームから取得する
     */
    private void getFieldValue() {
        this.configData.setCardNumber(this.jCardNumberField.getText());
        this.configData.setPassword(PasswordUtility.encode(new String(this.jPasswordField.getPassword())));
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField jCardNumberField;
    private javax.swing.JLabel jCardNumberLabel;
    private javax.swing.JPanel jConfigPanel;
    private javax.swing.JPasswordField jPasswordField;
    private javax.swing.JLabel jPasswordLabel;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JButton jStartButton;
    private javax.swing.JButton jStopButton;
    private javax.swing.JTextArea jTextArea;
    private javax.swing.JCheckBox jTodoFixSongDataCheckBox;
    private javax.swing.JPanel jTodoPanel;
    private javax.swing.JCheckBox jTodoSeimitsu2CheckBox;
    private javax.swing.JCheckBox jTodoSeimitsuCheckBox;
    // End of variables declaration//GEN-END:variables

}
