/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package jp.sourceforge.damstation_dl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import jp.sourceforge.damstation_dl.data.ConfigData;
import jp.sourceforge.damstation_dl.data.PasswordUtility;
import jp.sourceforge.damstation_dl.data.ResultData;
import jp.sourceforge.damstation_dl.data.ResultData2;
import jp.sourceforge.damstation_dl.data.ResultDataList;
import jp.sourceforge.damstation_dl.data.ResultData2List;
import jp.sourceforge.damstation_dl.data.ResultDate;
import jp.sourceforge.damstation_dl.data.SongData;
import jp.sourceforge.damstation_dl.data.SongDataList;
import jp.sourceforge.damstation_dl.data.SongId;

/**
 *
 * @author d
 */
public class DownloadThread extends SwingWorker<Object, String> {
    private final JButton button;
    private final JTextArea textArea;
    private ConfigData configData;
    private final SongDataList songData;
    private final ResultDataList resultData;
    private final ResultData2List resultData2;
    private final TodoData todoData;

    /**
     * コンストラクタ
     * @param button
     * @param textArea
     * @param configData
     * @param songData
     * @param resultData
     */
    public DownloadThread(JButton button, JTextArea textArea, ConfigData configData, SongDataList songData, ResultDataList resultData, ResultData2List resultData2, TodoData todoData) {
        if ((button == null) || (textArea == null) || (configData == null)
                || (songData == null) || (resultData == null) || (resultData2 == null)) {
            throw new NullPointerException("DownloadThread.DownloadThread");
        }

        this.button = button;
        this.textArea = textArea;
        this.configData = configData;
        this.songData = songData;
        this.resultData = resultData;
        this.resultData2 = resultData2;
        this.todoData = todoData;

        button.setEnabled(false);
    }

    /**
     * スレッド動作開始
     * バックグラウンドスレッドで動作
     * @return
     * @throws java.lang.Exception
     */
    @Override
    public Object doInBackground() throws Exception {
        // キャンセル判定
        if (this.isCancelled()) {
            this.publish("エラー：処理を中断しました。\n");
            return null;
        }
            
        if (this.configData.getCardNumber().isEmpty()) {
            this.publish("エラー：カード番号を入力してください。\n");
            this.publish("エラー：処理を中断しました。\n");
            return null;
        } else if ((PasswordUtility.decode(this.configData.getPassword())).isEmpty()) {
            this.publish("エラー：パスワードを入力してください。\n");
            this.publish("エラー：処理を中断しました。\n");
            return null;
        }

        this.publish("処理を開始します。\n");

        try {
            String source;
            TextDownloader downloader = new TextDownloader(
                    this.configData.getConnectTimeout(), this.configData.getReadTimeout(), this.configData.getProxy());
            
            // ログインページに接続する
            this.publish("ログインページに接続します。\n");
            source = this.getLoginPageSource(downloader);
            
            // キャンセル判定
            if (this.isCancelled()) {
                this.publish("エラー：処理を中断しました。\n");
                return null;
            }
            
            // ログインに成功したかどうか調べる
            if (!this.isLogin(source)) {
                this.publish("エラー：ログインに失敗しました。\n");
                this.publish("エラー：処理を中断しました。\n");
                return null;
            }
            this.publish("ログインに成功しました。\n");
            
            // キャンセル判定
            if (this.isCancelled()) {
                this.publish("エラー：処理を中断しました。\n");
                return null;
            }
            
            if (this.todoData.isDownloadSeimitsu()) {
                for (int page = 1; page <= 10; page++) {
                    // 精密採点ページに接続する
                    this.publish("精密採点の" + page + "ページ目に接続します。\n");
                    source = this.getSeimitsuPageSource(downloader, page);

                    // キャンセル判定
                    if (this.isCancelled()) {
                        this.publish("エラー：処理を中断しました。\n");
                        return null;
                    }

                    // 精密採点のソースを解析してデータに追加する
                    this.updateResultData(source, page);

                    // キャンセル判定
                    if (this.isCancelled()) {
                        this.publish("エラー：処理を中断しました。\n");
                        return null;
                    }
                }
            }
            
            if (this.todoData.isDownloadSeimitsu2()) {
                for (int page = 1; page <= 10; page++) {
                    // 精密採点IIページに接続する
                    this.publish("精密採点IIの" + page + "ページ目に接続します。\n");
                    source = this.getSeimitsu2PageSource(downloader, page);

                    // キャンセル判定
                    if (this.isCancelled()) {
                        this.publish("エラー：処理を中断しました。\n");
                        return null;
                    }

                    // 精密採点IIのソースを解析して、データに追加する
                    this.updateResultData2(source, page);

                    // キャンセル判定
                    if (this.isCancelled()) {
                        this.publish("エラー：処理を中断しました。\n");
                        return null;
                    }
                }
            }
        } catch (Exception e) {
            this.publish("エラー：例外が発生しました。\n");
            this.publish(e.toString() + "\n");
            this.publish("エラー：処理を中断しました。\n");
            return null;
        }

        this.publish("処理が完了しました。\n");
        return null;
    }

    /**
     * publishで設定された引数をこの関数で処理する
     * イベントディスパッチスレッドで動作
     * @param chunks
     */
    @Override
    protected void process(List<String> chunks) {
        for (String message : chunks) {
            if (!this.isCancelled()) {
                this.textArea.append(message);
            }
        }
    }
    
    /**
     * cancelメソッドが呼び出された時
     * あるいはdoInBackground終了時のどちらか早かった方で1度だけ呼ばれる
     * イベントディスパッチスレッドで動作
     */
    @Override
    protected void done() {
        if (this.isCancelled()) {
            this.textArea.append("エラー：処理を中断しました。\n");
        }
        this.button.setEnabled(true);
    }
    
    /**
     * ログインページを取得する
     * @return
     * @throws java.io.IOException
     */
    public String getLoginPageSource(TextDownloader downloader) throws IOException {
        // ログインページにアクセスしてページの内容を取得
        Map<String, String> loginPostValues = new HashMap<String, String>();
        loginPostValues.put("cardNumber", this.configData.getCardNumber());
        loginPostValues.put("password", PasswordUtility.decode(this.configData.getPassword()));
        
        return downloader.download("https://www.clubdam.com/app/auth/memMemberLogin.do", loginPostValues);
    }

    /**
     * DAMステーションのサイトにログインする
     * @param source
     * @return ログインの成否
     */
    public boolean isLogin(String source) throws IOException {

        // ログインページにアクセスしてページの内容を取得
        Map<String, String> loginPostValues = new HashMap<String, String>();
        loginPostValues.put("cardNumber", this.configData.getCardNumber());
        loginPostValues.put("password", PasswordUtility.decode(this.configData.getPassword()));

        // ログインページのパース
        return new LoginPageParser(new BufferedReader(new StringReader(source))).isLogin();
    }
    
    public String getSeimitsuPageSource(TextDownloader downloader, int page) throws IOException {
        return downloader.download("https://www.clubdam.com/app/membership/marking/listUp.do?page=" + page);
    }
    
    /**
     * 最新の精密採点の結果を追加する
     * @param source
     * @param page
     */
    public void updateResultData(String source, int page) throws IOException {
        // パース
        SeimitsuPageParser parser = new SeimitsuPageParser(new BufferedReader(new StringReader(source)));

        Map<SongId, SongData> dlSongDataList = parser.getSongDataList();
        int updateSongDataCount = 0;
        
        synchronized (this.songData) {
            for (Map.Entry<SongId, SongData> entry : dlSongDataList.entrySet()) {
                if (!this.songData.hasSongData(entry.getKey())) {
                    this.songData.add(entry.getKey(), entry.getValue());
                    updateSongDataCount++;
                }
            }
        }
        this.publish("曲データに" + updateSongDataCount + "/" + dlSongDataList.size() + "件追加しました。\n");
        
        Map<ResultDate, ResultData> dlResultDataList = parser.getResultDataList();
        int updateResultDataCount = 0;
        
        synchronized (this.resultData) {
            for (Map.Entry<ResultDate, ResultData> entry : dlResultDataList.entrySet()) {
                if (!this.resultData.hasResultData(entry.getKey())) {
                    this.resultData.add(entry.getKey(), entry.getValue());
                    updateResultDataCount++;
                }
            }
        }
        this.publish("結果データに" + updateResultDataCount + "/" + dlResultDataList.size() + "件追加しました。\n");
    }
    
    public String getSeimitsu2PageSource(TextDownloader downloader, int page) throws IOException {
        return downloader.download("https://www.clubdam.com/app/membership/marking/listUpMarkingTwo.do?page=" + page);
    }
    
    /**
     * 最新の精密採点IIの結果を追加する
     * @param source
     * @param page
     */
    public void updateResultData2(String source, int page) throws IOException {
        // パース
        Seimitsu2PageParser parser = new Seimitsu2PageParser(new BufferedReader(new StringReader(source)));

        Map<SongId, SongData> dlSongDataList = parser.getSongDataList();
        int updateSongDataCount = 0;
        
        synchronized (this.songData) {
            for (Map.Entry<SongId, SongData> entry : dlSongDataList.entrySet()) {
                if (!this.songData.hasSongData(entry.getKey())) {
                    this.songData.add(entry.getKey(), entry.getValue());
                    updateSongDataCount++;
                }
            }
        }
        this.publish("曲データに" + updateSongDataCount + "/" + dlSongDataList.size() + "件追加しました。\n");
        
        Map<ResultDate, ResultData2> dlResultData2List = parser.getResultData2List();
        int updateResultData2Count = 0;
                
        synchronized (this.resultData2) {
            for (Map.Entry<ResultDate, ResultData2> entry : dlResultData2List.entrySet()) {
                if (!this.resultData2.hasResultData(entry.getKey())) {
                    this.resultData2.add(entry.getKey(), entry.getValue());
                    updateResultData2Count++;
                }
            }
        }
        this.publish("結果データに" + updateResultData2Count + "/" + dlResultData2List.size() + "件追加しました。\n");
    }
}