package yukihane.inqubus.cookie;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/**
 * WindowsのMS IE(7以降)のcookieを扱います.
 * @author rankingloid (nicorank)
 * @author hazychill (nicorank)
 * @author orz (saccubus)
 * @author yuki
 */
class CookieWinMsIe extends Cookie {

    /** <p>
     *  IE7/IE8/IE9 から user_session を取得。<br/>
     *  エラーが起こった場合、例外を投げずに空文字を返す
     *  </p>
     *  @return user_session
     */
    @Override
    protected String getNicoUserSession() throws IOException {

        final String userProfile = System.getenv("USERPROFILE");

        if (StringUtils.isNotEmpty(userProfile)) {
            final List<File> searchDirs = new ArrayList<>();
            // http://msdn.microsoft.com/en-us/library/aa385326(v=VS.85).aspx
            searchDirs.add(new File(userProfile + "/AppData/Roaming/Microsoft/Windows/Cookies/Low/"));
            searchDirs.add(new File(userProfile + "/AppData/Roaming/Microsoft/Windows/Cookies/"));
            // これは何だ？
            searchDirs.add(new File(userProfile + "/Cookies/"));

            return getUserSession("MS932", searchDirs.toArray(new File[0]));
        }
        return "";
    }
}
