package yukihane.inqubus.config;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.builder.ToStringBuilder;
import saccubus.FfmpegOption;
import saccubus.worker.profile.FfmpegProfile;

/**
 * コンフィグに設定された値を基にしたFfmpegProfile実装.
 * @author yuki
 */
public class ConfigFfmpegProfile implements FfmpegProfile {

    private final String extOption;
    private final String inOption;
    private final String mainOption;
    private final String outOption;
    private final String avOption;
    private final boolean resize;
    private final int resizeWidth;
    private final int resizeHeight;
    private final boolean adjustRatio;

    public ConfigFfmpegProfile() throws IOException {
        final Config p = Config.INSTANCE;

        if (p.getFfmpegOptionFile() != null) {
            final File file = new File(p.getFfmpegOptionFile());
            final FfmpegOption ffop = FfmpegOption.load(file);
            this.extOption = ffop.getExtOption();
            this.inOption = ffop.getInOption();
            this.mainOption = ffop.getMainOption();
            this.outOption = ffop.getMainOption();
            this.avOption = ffop.getAvfilterOption();
            this.resize = ffop.isResize();
            this.resizeWidth = ffop.getResizeWidth();
            this.resizeHeight = ffop.getResizeHeight();
            this.adjustRatio = ffop.isAdjustRatio();
        } else {
            this.extOption = p.getFfmpegExtension();
            this.inOption = p.getFfmpegInOption();
            this.mainOption = p.getFfmpegMainOption();
            this.outOption = p.getFfmpegOutOption();
            this.avOption = p.getFfmpegAvOption();
            this.resize = p.getFfmpegResizeEnable();
            this.resizeWidth = Integer.parseInt(p.getFfmpegResizeWidth());
            this.resizeHeight = Integer.parseInt(p.getFfmpegResizeHeight());
            this.adjustRatio = p.getFfmpegKeepAspect();
        }
    }

    @Override
    public String getExtOption() {
        if (this.extOption.startsWith(".")) {
            return this.extOption;
        }
        return "." + this.extOption;
    }

    @Override
    public String getInOption() {
        return this.inOption;
    }

    @Override
    public String getMainOption() {
        return this.mainOption;
    }

    @Override
    public String getOutOption() {
        return this.outOption;
    }

    @Override
    public String getAvfilterOption() {
        return this.avOption;
    }

    @Override
    public boolean isResize() {
        return this.resize;
    }

    @Override
    public int getResizeWidth() {
        return this.resizeWidth;
    }

    @Override
    public int getResizeHeight() {
        return this.resizeHeight;
    }

    @Override
    public boolean isAdjustRatio() {
        return this.adjustRatio;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}