package yukihane.inqubus.config;

import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import saccubus.worker.profile.ConvertProfile;
import saccubus.worker.profile.FfmpegProfile;
import saccubus.worker.profile.GeneralProfile;

/**
 * コンフィグに設定された値を基にしたConvertProfile実装.
 * @author yuki
 */
public abstract class ConfigConvertProfile implements ConvertProfile {

    private final GeneralProfile generalProfile;
    private final FfmpegProfile ffmpegProfile;
    private final boolean convert;
    private final File ffmpeg;
    private final boolean vhookDisabled;
    private final boolean commentOverlay;
    private final File vhook;
    private final File mediaInfo;
    private final File tempDir;
    private final File font;
    private final int fontIndex;
    private final boolean commentOpaque;
    private final boolean disableFontSizeArrange;
    private final int shadowIndex;
    private final boolean showConverting;
    private final int maxNumOfComment;
    private final HideCondition ngSetting;

    public ConfigConvertProfile() throws IOException {
        final Config p = Config.INSTANCE;
        this.generalProfile = new ConfigGeneralProfile();
        this.ffmpegProfile = new ConfigFfmpegProfile();
        this.convert = p.getOutputEnable();
        this.ffmpeg = new File(p.getFfmpegPath());
        this.vhookDisabled = p.getFfmpegDllDisabled();
        this.commentOverlay = p.getOutputCommentOverlay();
        this.vhook = new File(p.getFfmpegDllPath());
        this.mediaInfo = new File(p.getMediaInfoPath());
        this.tempDir = new File(p.getSystemTempDir());
        this.font = new File(p.getFontPath());
        this.fontIndex = Integer.parseInt(p.getFontIndex());
        this.commentOpaque = p.getCommentOpaque();
        this.disableFontSizeArrange = p.getFontSizeArrangeDisable();
        this.shadowIndex = p.getFontShadow();
        this.showConverting = p.getFfmpegDisplayConverting();
        this.maxNumOfComment = (p.getCommentDisplaySizeDefault()) ? -1 : Integer.parseInt(p.getCommentDisplaySizeManual());
        this.ngSetting = new ConfigHideCondition();

    }

    @Override
    public GeneralProfile getGeneralProfile() {
        return generalProfile;
    }

    @Override
    public FfmpegProfile getFfmpegOption() {
        return ffmpegProfile;
    }

    @Override
    public boolean isConvert() {
        return convert;
    }

    @Override
    public File getFfmpeg() {
        return ffmpeg;
    }

    @Override
    public boolean isVhookDisabled() {
        return vhookDisabled;
    }

    @Override
    public boolean isCommentOverlay() {
        return commentOverlay;
    }

    @Override
    public File getVhook() {
        return vhook;
    }

    @Override
    public File getMediaInfo() {
        return mediaInfo;
    }

    @Override
    public File getTempDir() {
        return tempDir;
    }

    @Override
    public File getFont() {
        return font;
    }

    @Override
    public int getFontIndex() {
        return fontIndex;
    }

    @Override
    public boolean isCommentOpaque() {
        return commentOpaque;
    }

    @Override
    public boolean isDisableFontSizeArrange() {
        return disableFontSizeArrange;
    }

    @Override
    public int getShadowIndex() {
        return shadowIndex;
    }

    @Override
    public boolean isShowConverting() {
        return showConverting;
    }

    @Override
    public int getMaxNumOfComment() {
        return maxNumOfComment;
    }

    @Override
    public HideCondition getNgSetting() {
        return ngSetting;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}

class ConfigHideCondition implements ConvertProfile.HideCondition {

    private final String word;
    private final String id;

    ConfigHideCondition() {
        final Config p = Config.INSTANCE;
        this.word = StringUtils.join(p.getNgWords(), ' ');
        this.id = StringUtils.join(p.getNgIds(), ' ');
    }

    @Override
    public String getWord() {
        return word;
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
