package yukihane.inqubus.gui;

import java.awt.Dimension;
import javax.swing.JComboBox;
import javax.swing.JTextField;

/**
 * ComboBoxの幅に入りきらない場合はリストを拡張します.
 * http://www.jroller.com/santhosh/entry/make_jcombobox_popup_wide_enough
 * @author yuki
 */
class FileComboBox extends JComboBox<String> {

    private static final long serialVersionUID = 1L;
    private boolean layingOut = false;

    FileComboBox() {
        super();
        setEditable(true);
    }

    JTextField getEditorComponent() {
        return (JTextField) getEditor().getEditorComponent();
    }

    @Override
    public void doLayout() {
        try {
            layingOut = true;
            super.doLayout();
        } finally {
            layingOut = false;
        }
    }

    @Override
    public Dimension getSize() {
        Dimension dim = super.getSize();
        if (!layingOut) {
            dim.width = Math.max(dim.width, getPreferredSize().width);
        }
        return dim;
    }
}
