package yukihane.inqubus.filewatch;

import static yukihane.inqubus.InqubusConstants.*;

import java.nio.file.Path;
import java.util.Collection;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import org.apache.commons.io.FilenameUtils;

/**
 *
 * @author yuki
 */
public final class FileWatchUtil {

    private FileWatchUtil() {
    }

    /**
     * 指定された文字列で始まる動画IDを検索します.
     * @param paths 検索対象のファイルパス.
     * @param startText この文字で始まる動画ID一覧を出力します.
     * @return 条件に当てはまる動画ID一覧.
     */
    public static SortedSet<String> getVideoIdsStartWith(Collection<Path> paths, String startText) {
        final SortedSet<String> set = new TreeSet<>();
        for (Path p : paths) {
            final String name = FilenameUtils.getBaseName(p.toString());
            final Matcher m = PATTERN_VIDEO_ID.matcher(name);
            while (m.find()) {
                final String alt = m.group(1);
                if (alt.startsWith(startText)) {
                    set.add(alt);
                }
            }
        }
        return set;
    }

    /**
     * 指定した文字列を含むファイル名一覧を取得します.
     * @param paths 検索対象のファイルパス.
     * @param text ファイル名にこの文字列を含むパスを抽出します.
     * @return 条件に合致するファイルのフルパス.
     */
    public static SortedSet<String> getFileNamesContain(Collection<Path> paths, String text) {
        final SortedSet<String> set = new TreeSet<>();
        for (Path p : paths) {
            final String name = FilenameUtils.getBaseName(p.toString());
            final Matcher m = PATTERN_VIDEO_ID.matcher(name);
            while (m.find()) {
                final String alt = m.group(1);
                if (alt.equals(text)) {
                    set.add(p.toAbsolutePath().toString());
                    break;
                }
            }
        }
        return set;
    }
}
