package nicobrowser.util

/**
 * http://ext.nicovideo.jp/api/getthumbinfo/sm** のInputStreamからエンティティを生成します.
 * @author yuki
 */
class RssContentParser {
    RssContent parse(InputStream is){
        def xml = new XmlSlurper().parse(is)
        def t = xml.thumb[0]

        new RssContent(
            video_id: t.video_id[0].text(),
            title: t.title[0].text(),
            description: t.description[0].text(),
            thumbnail_url: t.thumbnail_url[0].text(),
            first_retrieve: t.first_retrieve[0].text(),
            length: t.length[0].text(),
            movie_type: t.movie_type[0].text(),
            size_high: t.size_high[0].text(),
            size_low: t.size_low[0].text(),
            view_counter: t.view_counter[0].text(),
            comment_num: t.comment_num[0].text(),
            mylist_counter: t.mylist_counter[0].text(),
            last_res_body: t.last_res_body[0].text(),
            watch_url: t.watch_url[0].text(),
            thumb_type: t.thumb_type[0].text(),
            embeddable: t.embeddable[0].text(),
            no_live_play: t.no_live_play[0].text()
            )
    }
}
