/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.scostore;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.Transaction;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.metadata.CollectionMetaData;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.scostore.AbstractCollectionStore;
import org.datanucleus.store.mapped.scostore.AbstractListStoreSpecialization;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.scostore.ListStore;

public abstract class AbstractListStore
extends AbstractCollectionStore
implements ListStore {
    protected String listName;
    protected boolean indexedList = true;

    protected AbstractListStore(StoreManager storeMgr, ClassLoaderResolver clr, AbstractListStoreSpecialization specialization) {
        super(storeMgr, clr, specialization);
    }

    public Iterator iterator(StateManager sm) {
        return this.listIterator(sm);
    }

    public ListIterator listIterator(StateManager sm) {
        return this.listIterator(sm, 0);
    }

    public ListIterator listIterator(StateManager ownerSM, int start) {
        QueryExpression stmt = null;
        stmt = start >= 0 ? this.getIteratorStatement(ownerSM, start, -1) : this.getIteratorStatement(ownerSM, -1, -1);
        ResultObjectFactory rof = this.newResultObjectFactory(ownerSM, stmt, false, true);
        ObjectManager om = ownerSM.getObjectManager();
        Transaction tx = om.getTransaction();
        boolean useUpdateLock = (Boolean)tx.getOptions().get("transaction.serializeReadObjects");
        return this.getSpecialization().listIterator(stmt, useUpdateLock, om, ownerSM, rof, this);
    }

    public boolean add(StateManager sm, Object element, int size) {
        return this.internalAdd(sm, 0, true, Collections.singleton(element), size);
    }

    public void add(StateManager sm, Object element, int index, int size) {
        this.internalAdd(sm, index, false, Collections.singleton(element), size);
    }

    public boolean addAll(StateManager sm, Collection elements, int size) {
        return this.internalAdd(sm, 0, true, elements, size);
    }

    public boolean addAll(StateManager sm, Collection elements, int index, int size) {
        return this.internalAdd(sm, index, false, elements, size);
    }

    protected abstract boolean internalAdd(StateManager var1, int var2, boolean var3, Collection var4, int var5);

    public Object get(StateManager sm, int index) {
        List list = this.internalGetRange(sm, index, index);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public int indexOf(StateManager sm, Object element) {
        this.validateElementForReading(sm, element);
        return this.getSpecialization().indexOf(sm, element, this);
    }

    public int lastIndexOf(StateManager sm, Object element) {
        this.validateElementForReading(sm, element);
        return this.getSpecialization().lastIndexOf(sm, element, this);
    }

    public boolean removeAll(StateManager sm, Collection elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        boolean modified = false;
        if (this.indexedList) {
            int[] indices = this.getIndicesOf(sm, elements);
            for (int i = 0; i < indices.length; ++i) {
                this.removeAt(sm, indices[i], -1);
                modified = true;
            }
        } else {
            throw new NucleusException("Not yet implemented AbstractListStore.remove for ordered lists");
        }
        if (this.ownerMemberMetaData.getCollection().isDependentElement()) {
            sm.getObjectManager().deleteObjects(elements.toArray());
        }
        return modified;
    }

    public boolean remove(StateManager sm, Object element, int size, boolean allowDependentField) {
        if (!this.validateElementForReading(sm, element)) {
            return false;
        }
        Object elementToRemove = element;
        ObjectManager om = sm.getObjectManager();
        if (om.getApiAdapter().isDetached(element)) {
            elementToRemove = om.findObject(om.getApiAdapter().getIdForObject(element), true, false, element.getClass().getName());
        }
        boolean modified = this.internalRemove(sm, elementToRemove, size);
        CollectionMetaData collmd = this.ownerMemberMetaData.getCollection();
        if (allowDependentField && collmd.isDependentElement() && !collmd.isEmbeddedElement()) {
            sm.getObjectManager().deleteObjectInternal(elementToRemove);
        }
        return modified;
    }

    protected abstract boolean internalRemove(StateManager var1, Object var2, int var3);

    public Object remove(StateManager sm, int index, int size) {
        Object element = this.get(sm, index);
        this.removeAt(sm, index, size);
        CollectionMetaData collmd = this.ownerMemberMetaData.getCollection();
        if (collmd.isDependentElement() && !collmd.isEmbeddedElement() && !this.contains(sm, element)) {
            sm.getObjectManager().deleteObjectInternal(element);
        }
        return element;
    }

    protected abstract void removeAt(StateManager var1, int var2, int var3);

    public List subList(StateManager sm, int start, int end) {
        return this.internalGetRange(sm, start, end);
    }

    protected int[] getIndicesOf(StateManager sm, Collection elements) {
        if (elements == null || elements.size() == 0) {
            return null;
        }
        for (Object element : elements) {
            this.validateElementForReading(sm, element);
        }
        return this.getSpecialization().getIndicesOf(sm, elements, this);
    }

    protected abstract QueryExpression getIteratorStatement(StateManager var1, int var2, int var3);

    protected List internalGetRange(StateManager sm, int start, int end) {
        ObjectManager om = sm.getObjectManager();
        QueryExpression stmt = this.getIteratorStatement(sm, start, end);
        ResultObjectFactory getROF = this.newResultObjectFactory(sm, stmt, false, true);
        Transaction tx = om.getTransaction();
        boolean useUpdateLock = (Boolean)tx.getOptions().get("transaction.serializeReadObjects");
        return this.getSpecialization().internalGetRange(om, useUpdateLock, stmt, getROF, this);
    }

    private AbstractListStoreSpecialization getSpecialization() {
        return (AbstractListStoreSpecialization)this.specialization;
    }
}

