/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.store.mapped.StatementMappingIndex;

public class StatementMappingForClass {
    public static int MEMBER_DATASTORE_ID = -1;
    public static int MEMBER_VERSION = -2;
    public static int MEMBER_DISCRIMINATOR = -3;
    String memberName;
    String nucleusTypeColumn;
    int[] memberNumbers;
    Map<Integer, StatementMappingIndex> mappings = new HashMap<Integer, StatementMappingIndex>();
    Map<Integer, StatementMappingForClass> children;

    public StatementMappingForClass(String memberName) {
        this.memberName = memberName;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public void setNucleusTypeColumnName(String colName) {
        this.nucleusTypeColumn = colName;
    }

    public String getNucleusTypeColumnName() {
        return this.nucleusTypeColumn;
    }

    public StatementMappingIndex getMappingForMemberPosition(int position) {
        return this.mappings.get(position);
    }

    public StatementMappingForClass getMappingDefinitionForMemberPosition(int position) {
        if (this.children != null) {
            return this.children.get(position);
        }
        return null;
    }

    public boolean hasChildMappingDefinitions() {
        return this.children != null && this.children.size() > 0;
    }

    public int[] getMemberNumbers() {
        if (this.memberNumbers != null) {
            return this.memberNumbers;
        }
        int length = this.mappings.size();
        if (this.mappings.containsKey(MEMBER_DATASTORE_ID)) {
            --length;
        }
        if (this.mappings.containsKey(MEMBER_VERSION)) {
            --length;
        }
        if (this.mappings.containsKey(MEMBER_DISCRIMINATOR)) {
            --length;
        }
        int[] positions = new int[length];
        Iterator<Integer> iter = this.mappings.keySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            Integer val = iter.next();
            if (val < 0) continue;
            positions[i++] = val;
        }
        this.memberNumbers = positions;
        return positions;
    }

    public void addMappingForMember(int position, StatementMappingIndex mapping) {
        this.memberNumbers = null;
        this.mappings.put(position, mapping);
    }

    public void addMappingDefinitionForMember(int position, StatementMappingForClass defn) {
        this.memberNumbers = null;
        if (this.children == null) {
            this.children = new HashMap<Integer, StatementMappingForClass>();
        }
        this.children.put(position, defn);
    }

    public StatementMappingForClass cloneStatementMappingWithoutChildren() {
        StatementMappingForClass mapping = new StatementMappingForClass(this.memberName);
        mapping.nucleusTypeColumn = this.nucleusTypeColumn;
        for (Map.Entry<Integer, StatementMappingIndex> entry : this.mappings.entrySet()) {
            Integer key = entry.getKey();
            StatementMappingIndex value = entry.getValue();
            mapping.addMappingForMember(key, value);
        }
        return mapping;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("StatementMapping:");
        Iterator<Map.Entry<Integer, StatementMappingIndex>> mapIter = this.mappings.entrySet().iterator();
        while (mapIter.hasNext()) {
            Map.Entry<Integer, StatementMappingIndex> entry = mapIter.next();
            str.append(" field=").append(entry.getKey());
            str.append(" mapping=").append(entry.getValue());
            if (!mapIter.hasNext() && this.children == null) continue;
            str.append(",");
        }
        if (this.children != null) {
            Iterator<Map.Entry<Integer, StatementMappingForClass>> childIter = this.children.entrySet().iterator();
            while (childIter.hasNext()) {
                Map.Entry<Integer, StatementMappingForClass> entry = childIter.next();
                str.append(" field=").append(entry.getKey());
                str.append(" mapping=").append(entry.getValue());
                if (!childIter.hasNext()) continue;
                str.append(",");
            }
        }
        return str.toString();
    }
}

