/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.query.compiler;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.query.expression.Expression;
import org.datanucleus.query.symbol.Symbol;
import org.datanucleus.query.symbol.SymbolTable;
import org.datanucleus.store.query.QueryInvalidParametersException;
import org.datanucleus.util.Localiser;

public class QueryCompilation {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ObjectManagerFactoryImpl.class.getClassLoader());
    protected Class candidateClass;
    protected String candidateAlias = "this";
    protected boolean returnsSingleRow = false;
    protected SymbolTable symtbl;
    protected Expression[] exprResult;
    protected Expression[] exprFrom;
    protected Expression exprFilter = null;
    protected Expression[] exprGrouping;
    protected Expression exprHaving;
    protected Expression[] exprOrdering;
    protected Map<String, QueryCompilation> subqueryCompilations = null;

    public QueryCompilation(Class candidateCls, String candidateAlias, SymbolTable symtbl, Expression[] results, Expression[] froms, Expression filter, Expression[] groupings, Expression having, Expression[] orderings) {
        this.candidateClass = candidateCls;
        this.candidateAlias = candidateAlias;
        this.symtbl = symtbl;
        this.exprResult = results;
        this.exprFrom = froms;
        this.exprFilter = filter;
        this.exprGrouping = groupings;
        this.exprHaving = having;
        this.exprOrdering = orderings;
    }

    public void setReturnsSingleRow() {
        this.returnsSingleRow = true;
    }

    public void addSubqueryCompilation(String alias, QueryCompilation compilation) {
        if (this.subqueryCompilations == null) {
            this.subqueryCompilations = new HashMap<String, QueryCompilation>();
        }
        this.subqueryCompilations.put(alias, compilation);
    }

    public QueryCompilation getCompilationForSubquery(String alias) {
        return this.subqueryCompilations != null ? this.subqueryCompilations.get(alias) : null;
    }

    public String[] getSubqueryAliases() {
        if (this.subqueryCompilations == null || this.subqueryCompilations.isEmpty()) {
            return null;
        }
        String[] aliases = new String[this.subqueryCompilations.size()];
        Iterator<String> iter = this.subqueryCompilations.keySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            aliases[i++] = iter.next();
        }
        return aliases;
    }

    public boolean returnsSingleRow() {
        return this.returnsSingleRow;
    }

    public Class[] getResultTypes() {
        if (this.exprResult != null && this.exprResult.length > 0) {
            Class[] results = new Class[this.exprResult.length];
            for (int i = 0; i < this.exprResult.length; ++i) {
                Symbol colSym = this.exprResult[i].getSymbol();
                results[i] = colSym.getValueType();
            }
            return results;
        }
        return new Class[]{this.candidateClass};
    }

    public Class getCandidateClass() {
        return this.candidateClass;
    }

    public String getCandidateAlias() {
        return this.candidateAlias;
    }

    public SymbolTable getSymbolTable() {
        return this.symtbl;
    }

    public Expression[] getExprResult() {
        return this.exprResult;
    }

    public Expression[] getExprFrom() {
        return this.exprFrom;
    }

    public Expression getExprFilter() {
        return this.exprFilter;
    }

    public Expression[] getExprGrouping() {
        return this.exprGrouping;
    }

    public Expression getExprHaving() {
        return this.exprHaving;
    }

    public Expression[] getExprOrdering() {
        return this.exprOrdering;
    }

    public void bindParameterValuesToNames(Map parameters) {
        if (parameters != null) {
            for (Map.Entry entry : parameters.entrySet()) {
                String paramName = (String)entry.getKey();
                Symbol symbol = this.symtbl.getSymbol(paramName);
                if (symbol != null) {
                    Class expectedValueType = symbol.getValueType();
                    if (entry.getValue() != null && expectedValueType != null && !expectedValueType.isAssignableFrom(entry.getValue().getClass())) {
                        throw new NucleusUserException("Parameter \"" + paramName + "\" was specified as " + entry.getValue().getClass().getName() + " but should have been " + expectedValueType.getClass().getName());
                    }
                    symbol.setValue(entry.getValue());
                    continue;
                }
                throw new QueryInvalidParametersException(LOCALISER.msg("021116", (Object)paramName));
            }
        }
    }

    public Object clone() {
        SymbolTable tbl = (SymbolTable)this.symtbl.clone();
        QueryCompilation compilation = new QueryCompilation(this.candidateClass, this.candidateAlias, tbl, this.exprResult, this.exprFrom, this.exprFilter, this.exprGrouping, this.exprHaving, this.exprOrdering);
        if (this.subqueryCompilations != null) {
            for (Map.Entry<String, QueryCompilation> entry : this.subqueryCompilations.entrySet()) {
                compilation.addSubqueryCompilation(entry.getKey(), entry.getValue());
            }
        }
        return compilation;
    }

    public String toString() {
        int i;
        StringBuilder str = new StringBuilder("QueryCompilation:");
        if (this.exprResult != null) {
            str.append(" [result:");
            for (i = 0; i < this.exprResult.length; ++i) {
                if (i > 0) {
                    str.append(",");
                }
                str.append(this.exprResult[i]);
            }
            str.append("]\n");
        }
        if (this.exprFrom != null) {
            str.append(" [from:");
            for (i = 0; i < this.exprFrom.length; ++i) {
                if (i > 0) {
                    str.append(",");
                }
                str.append(this.exprFrom[i]);
            }
            str.append("]\n");
        }
        if (this.exprFilter != null) {
            str.append(" [filter:").append(this.exprFilter).append("]\n");
        }
        if (this.exprGrouping != null) {
            str.append(" [grouping:");
            for (i = 0; i < this.exprGrouping.length; ++i) {
                if (i > 0) {
                    str.append(",");
                }
                str.append(this.exprGrouping[i]);
            }
            str.append("]\n");
        }
        if (this.exprHaving != null) {
            str.append(" [having:").append(this.exprHaving).append("]\n");
        }
        if (this.exprOrdering != null) {
            str.append(" [ordering:");
            for (i = 0; i < this.exprOrdering.length; ++i) {
                if (i > 0) {
                    str.append(",");
                }
                str.append(this.exprOrdering[i]);
            }
            str.append("]\n");
        }
        return str.toString();
    }
}

