/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.resources;

import java.io.IOException;
import java.net.URL;
import org.jboss.webbeans.resources.spi.ResourceLoader;
import org.jboss.webbeans.resources.spi.ResourceLoadingException;
import org.jboss.webbeans.util.EnumerationIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResourceLoader
implements ResourceLoader {
    @Override
    public Class<?> classForName(String name) {
        try {
            if (Thread.currentThread().getContextClassLoader() != null) {
                return Thread.currentThread().getContextClassLoader().loadClass(name);
            }
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new ResourceLoadingException(e);
        }
        catch (NoClassDefFoundError e) {
            throw new ResourceLoadingException(e);
        }
    }

    @Override
    public URL getResource(String name) {
        if (Thread.currentThread().getContextClassLoader() != null) {
            return Thread.currentThread().getContextClassLoader().getResource(name);
        }
        return this.getClass().getResource(name);
    }

    @Override
    public Iterable<URL> getResources(String name) {
        try {
            if (Thread.currentThread().getContextClassLoader() != null) {
                return new EnumerationIterable<URL>(Thread.currentThread().getContextClassLoader().getResources(name));
            }
            return new EnumerationIterable<URL>(this.getClass().getClassLoader().getResources(name));
        }
        catch (IOException e) {
            throw new ResourceLoadingException(e);
        }
    }
}

