/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.event;

import org.jboss.webbeans.context.ContextLifecycle;
import org.jboss.webbeans.context.api.helpers.ConcurrentHashMapBeanStore;
import org.jboss.webbeans.event.ObserverImpl;
import org.jboss.webbeans.log.Log;
import org.jboss.webbeans.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeferredEventNotification<T>
implements Runnable {
    private static Log log = Logging.getLog(DeferredEventNotification.class);
    protected ObserverImpl<T> observer;
    protected T event;

    public DeferredEventNotification(T event, ObserverImpl<T> observer) {
        this.observer = observer;
        this.event = event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ConcurrentHashMapBeanStore requestBeanStore = new ConcurrentHashMapBeanStore();
        ContextLifecycle.instance().beginRequest("async invocation", requestBeanStore);
        try {
            log.debug((Object)("Sending event [" + this.event + "] directly to observer " + this.observer), new Object[0]);
            this.observer.sendEvent(this.event);
        }
        catch (Exception e) {
            log.error((Object)("Failure while notifying an observer of event [" + this.event + "]"), e, new Object[0]);
        }
        finally {
            ContextLifecycle.instance().endRequest("async invocation", requestBeanStore);
        }
    }

    public String toString() {
        return "Deferred event [" + this.event + "] for [" + this.observer + "]";
    }
}

