/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.ejb;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.interceptor.InvocationContext;
import org.jboss.webbeans.CurrentManager;
import org.jboss.webbeans.bean.EnterpriseBean;
import org.jboss.webbeans.bean.proxy.EnterpriseBeanInstance;
import org.jboss.webbeans.bean.proxy.EnterpriseBeanProxyMethodHandler;
import org.jboss.webbeans.log.Log;
import org.jboss.webbeans.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionBeanInterceptor
implements Serializable {
    private transient Log log = Logging.getLog(SessionBeanInterceptor.class);
    private transient EnterpriseBean<Object> bean;
    private String beanId;
    private boolean contextual;

    @PostConstruct
    public void postConstruct(InvocationContext invocationContext) throws Exception {
        Object target = invocationContext.getTarget();
        this.initBean(target.getClass());
        this.bean.postConstruct(target);
        invocationContext.proceed();
    }

    @PreDestroy
    public void preDestroy(InvocationContext invocationContext) throws Exception {
        Object target = invocationContext.getTarget();
        if (this.bean == null) {
            this.log.warn((Object)"Support for destroying passivated EJBs not yet implemented", new Object[0]);
        }
        this.bean.preDestroy(target);
        if (this.contextual) {
            SessionBeanInterceptor.getEnterpriseBeanInstance(this.bean).setDestroyed(true);
        }
        invocationContext.proceed();
    }

    private void initBean(Class<? extends Object> beanClass) {
        EnterpriseBean<?> bean = EnterpriseBeanProxyMethodHandler.getEnterpriseBean();
        if (bean != null && bean.getType().equals(beanClass)) {
            this.bean = bean;
            this.contextual = true;
        } else {
            this.bean = CurrentManager.rootManager().getNewEnterpriseBeanMap().get(beanClass);
            this.contextual = false;
        }
        this.beanId = this.bean.getId();
    }

    private static <T> EnterpriseBeanInstance getEnterpriseBeanInstance(EnterpriseBean<T> bean) {
        T instance = CurrentManager.rootManager().getContext(bean.getScopeType()).get(bean);
        if (instance instanceof EnterpriseBeanInstance) {
            return (EnterpriseBeanInstance)instance;
        }
        throw new IllegalStateException("Contextual instance not an session bean created by the container");
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (this.beanId != null) {
            this.bean = (EnterpriseBean)CurrentManager.rootManager().getRiBeans().get(this.beanId);
        }
    }

    protected EnterpriseBean<Object> getBean() {
        return this.bean;
    }
}

