/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.cron;

import com.google.appengine.repackaged.com.google.cron.GrocLexer;
import com.google.appengine.repackaged.com.google.cron.GrocParser;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.IllegalFieldValueException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrocTimeSpecification {
    private final Set<Integer> months;
    private final Set<Integer> ordinals;
    private final Set<Integer> weekdays;
    private final Integer interval;
    private final String intervalPeriod;
    private final int hour;
    private final int minute;
    private final DateTimeZone timezone;
    private static final DateTimeZone UTC_ZONE = DateTimeZone.forID((String)"UTC");

    public static GrocTimeSpecification create(String spec, DateTimeZone timezone) throws IllegalArgumentException {
        GrocLexer lexer = new GrocLexer((CharStream)new ANTLRStringStream(spec));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        GrocParser parser = new GrocParser((TokenStream)tokens);
        parser.init();
        try {
            parser.timespec();
        }
        catch (RecognitionException e) {
            throw new IllegalArgumentException("Specification '" + spec + "' is invalid.");
        }
        if (timezone == null) {
            timezone = UTC_ZONE;
        }
        if (parser.getInterval() != null) {
            return new GrocTimeSpecification(parser.getInterval(), parser.getIntervalPeriod(), timezone);
        }
        return new GrocTimeSpecification(parser.getOrdinals(), parser.getMonths(), parser.getWeekdays(), parser.getTime(), timezone);
    }

    public static GrocTimeSpecification create(String spec) throws IllegalArgumentException {
        return GrocTimeSpecification.create(spec, UTC_ZONE);
    }

    public GrocTimeSpecification(Set<Integer> ordinals, Set<Integer> months, Set<Integer> weekdays, String time, DateTimeZone timezone) {
        this.timezone = timezone;
        this.ordinals = ordinals;
        this.months = months;
        this.weekdays = weekdays;
        String[] timeElements = time.split(":");
        this.hour = Integer.parseInt(timeElements[0]);
        this.minute = Integer.parseInt(timeElements[1]);
        this.interval = null;
        this.intervalPeriod = "";
    }

    public GrocTimeSpecification(int interval, String period, DateTimeZone timezone) {
        this.hour = 0;
        this.minute = 0;
        this.months = new HashSet<Integer>();
        this.ordinals = new HashSet<Integer>();
        this.weekdays = new HashSet<Integer>();
        this.timezone = timezone;
        this.interval = interval;
        this.intervalPeriod = period;
    }

    public List<DateTime> getMatches(DateTime start, int count) {
        ArrayList<DateTime> results = new ArrayList<DateTime>();
        DateTime next = start;
        for (int i = 0; i < count; ++i) {
            next = this.getMatch(next);
            results.add(next);
        }
        return results;
    }

    public DateTime getMatch(DateTime start) {
        if (this.interval != null) {
            return this.getMatchInterval(start);
        }
        return this.getMatchSpecificTime(start);
    }

    private DateTime getMatchInterval(DateTime start) {
        if (this.intervalPeriod.equals("hours")) {
            return start.plusHours(this.interval.intValue());
        }
        return start.plusMinutes(this.interval.intValue());
    }

    private DateTime getMatchSpecificTime(DateTime start) {
        DateTime result;
        NextGenerator monthGen = new NextGenerator(start.getMonthOfYear(), this.months);
        start = start.withZone(this.timezone);
        block4: while (true) {
            IntegerPair nextMonthWrapPair = monthGen.next();
            int nextMonth = nextMonthWrapPair.first;
            int yearWraps = nextMonthWrapPair.second;
            DateTime candidate = start.withDayOfMonth(1).withMonthOfYear(nextMonth).plusYears(yearWraps);
            List<Integer> dayMatches = this.findDays(candidate);
            if (dayMatches.size() == 0) {
                throw new AssertionError((Object)"no matching days");
            }
            if (candidate.getYear() == start.getYear() && candidate.getMonthOfYear() == start.getMonthOfYear()) {
                while (!dayMatches.isEmpty() && dayMatches.get(0) < start.getDayOfMonth()) {
                    dayMatches.remove(0);
                }
                if (!dayMatches.isEmpty() && dayMatches.get(0).intValue() == start.getDayOfMonth() && (start.getHourOfDay() > this.hour || start.getHourOfDay() == this.hour && start.getMinuteOfHour() >= this.minute)) {
                    dayMatches.remove(0);
                }
            }
            block6: while (true) {
                if (dayMatches.isEmpty()) continue block4;
                int candidateDay = dayMatches.get(0);
                dayMatches.remove(0);
                result = null;
                try {
                    result = candidate.withDayOfMonth(candidateDay).withHourOfDay(this.hour).withMinuteOfHour(this.minute).withSecondOfMinute(0);
                    break block4;
                }
                catch (IllegalFieldValueException e) {
                    for (int i = 1; i < 25; ++i) {
                        try {
                            result = candidate.withDayOfMonth(candidateDay).withHourOfDay(this.hour + i).withMinuteOfHour(1).withSecondOfMinute(0);
                            continue block6;
                        }
                        catch (IllegalFieldValueException e2) {
                            continue;
                        }
                    }
                    if (result == null) continue;
                }
                break;
            }
            break;
        }
        result = result.withZone(UTC_ZONE);
        return result;
    }

    List<Integer> findDays(DateTime candidate) {
        TreeSet<Integer> outDays = new TreeSet<Integer>();
        int firstWeekDay = candidate.dayOfMonth().withMinimumValue().getDayOfWeek();
        firstWeekDay %= 7;
        int lastDayOfMonth = candidate.dayOfMonth().withMaximumValue().getDayOfMonth();
        for (int ordinal : this.ordinals) {
            for (int weekday : this.weekdays) {
                int day = (7 + weekday - firstWeekDay) % 7 + 1;
                if ((day += 7 * (ordinal - 1)) > lastDayOfMonth) continue;
                outDays.add(day);
            }
        }
        return new ArrayList<Integer>(outDays);
    }

    static class IntegerPair {
        public final int first;
        public final int second;

        IntegerPair(int first, int second) {
            this.first = first;
            this.second = second;
        }

        public boolean equals(Object other) {
            return other instanceof IntegerPair && this.first == ((IntegerPair)other).first && this.second == ((IntegerPair)other).second;
        }

        public String toString() {
            return "<" + this.first + "," + this.second + ">";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NextGenerator {
        private int start;
        private final Set<Integer> matches;
        private List<Integer> remaining;
        private int wrapcount;

        NextGenerator(Integer start, Set<Integer> matches) {
            this.start = start;
            this.matches = new TreeSet<Integer>(matches);
            this.remaining = new ArrayList<Integer>(this.matches);
            this.wrapcount = 0;
        }

        public IntegerPair next() {
            while (this.remaining.size() > 0 && this.remaining.get(0) < this.start) {
                this.remaining.remove(0);
            }
            if (this.remaining.size() == 0) {
                this.remaining = new ArrayList<Integer>(this.matches);
                ++this.wrapcount;
            }
            this.start = this.remaining.get(0);
            this.remaining.remove(0);
            return new IntegerPair(this.start, this.wrapcount);
        }
    }
}

