/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.validation.validator;

import java.util.Map;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.validator.AbstractValidator;

public abstract class StringValidator
extends AbstractValidator {
    private static final long serialVersionUID = 1L;

    public static StringValidator exactLength(int length) {
        return new ExactLengthValidator(length);
    }

    public static StringValidator lengthBetween(int minimum, int maximum) {
        return new LengthBetweenValidator(minimum, maximum);
    }

    public static StringValidator maximumLength(int maximum) {
        return new MaximumLengthValidator(maximum);
    }

    public static StringValidator minimumLength(int minimum) {
        return new MinimumLengthValidator(minimum);
    }

    public static class MinimumLengthValidator
    extends StringValidator {
        private static final long serialVersionUID = 1L;
        private final int minimum;

        public MinimumLengthValidator(int minimum) {
            this.minimum = minimum;
        }

        public final int getMinimum() {
            return this.minimum;
        }

        protected void onValidate(IValidatable validatable) {
            if (((String)validatable.getValue()).length() < this.minimum) {
                this.error(validatable);
            }
        }

        protected String resourceKey() {
            return "StringValidator.minimum";
        }

        protected Map variablesMap(IValidatable validatable) {
            Map map = super.variablesMap(validatable);
            map.put("minimum", new Integer(this.minimum));
            map.put("length", new Integer(((String)validatable.getValue()).length()));
            return map;
        }
    }

    public static class MaximumLengthValidator
    extends StringValidator {
        private static final long serialVersionUID = 1L;
        private final int maximum;

        public MaximumLengthValidator(int maximum) {
            this.maximum = maximum;
        }

        public final int getMaximum() {
            return this.maximum;
        }

        protected void onValidate(IValidatable validatable) {
            if (((String)validatable.getValue()).length() > this.maximum) {
                this.error(validatable);
            }
        }

        protected String resourceKey() {
            return "StringValidator.maximum";
        }

        protected Map variablesMap(IValidatable validatable) {
            Map map = super.variablesMap(validatable);
            map.put("maximum", new Integer(this.maximum));
            map.put("length", new Integer(((String)validatable.getValue()).length()));
            return map;
        }
    }

    public static class LengthBetweenValidator
    extends StringValidator {
        private static final long serialVersionUID = 1L;
        private final int maximum;
        private final int minimum;

        public LengthBetweenValidator(int minimum, int maximum) {
            this.minimum = minimum;
            this.maximum = maximum;
        }

        public final int getMaximum() {
            return this.maximum;
        }

        public final int getMinimum() {
            return this.minimum;
        }

        protected void onValidate(IValidatable validatable) {
            String value = (String)validatable.getValue();
            if (value.length() < this.minimum || value.length() > this.maximum) {
                this.error(validatable);
            }
        }

        protected String resourceKey() {
            return "StringValidator.range";
        }

        protected Map variablesMap(IValidatable validatable) {
            Map map = super.variablesMap(validatable);
            map.put("minimum", new Integer(this.minimum));
            map.put("maximum", new Integer(this.maximum));
            map.put("length", new Integer(((String)validatable.getValue()).length()));
            return map;
        }
    }

    public static class ExactLengthValidator
    extends StringValidator {
        private static final long serialVersionUID = 1L;
        private final int length;

        public ExactLengthValidator(int length) {
            this.length = length;
        }

        public final int getLength() {
            return this.length;
        }

        protected void onValidate(IValidatable validatable) {
            if (((String)validatable.getValue()).length() != this.length) {
                this.error(validatable);
            }
        }

        protected String resourceKey() {
            return "StringValidator.exact";
        }

        protected Map variablesMap(IValidatable validatable) {
            Map map = super.variablesMap(validatable);
            map.put("length", new Integer(((String)validatable.getValue()).length()));
            map.put("exact", new Integer(this.length));
            return map;
        }
    }
}

