/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.request;

import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.protocol.http.ClientProperties;
import org.apache.wicket.protocol.http.WebRequestCycle;
import org.apache.wicket.request.ClientInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebClientInfo
extends ClientInfo {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger((Class)WebClientInfo.class);
    private final String userAgent;
    private final ClientProperties properties = new ClientProperties();

    public WebClientInfo(WebRequestCycle requestCycle) {
        HttpServletRequest httpServletRequest = requestCycle.getWebRequest().getHttpServletRequest();
        this.userAgent = httpServletRequest.getHeader("User-Agent");
        this.properties.setRemoteAddress(this.getRemoteAddr(requestCycle));
        this.init();
    }

    public WebClientInfo(WebRequestCycle requestCycle, String userAgent) {
        this.userAgent = userAgent;
        HttpServletRequest httpServletRequest = requestCycle.getWebRequest().getHttpServletRequest();
        this.properties.setRemoteAddress(this.getRemoteAddr(requestCycle));
        this.init();
    }

    public final ClientProperties getProperties() {
        return this.properties;
    }

    public final String getUserAgent() {
        return this.userAgent;
    }

    protected String getRemoteAddr(WebRequestCycle requestCycle) {
        HttpServletRequest httpServletReq = requestCycle.getWebRequest().getHttpServletRequest();
        String remoteAddr = httpServletReq.getHeader("X-Forwarded-For");
        if (remoteAddr == null) {
            remoteAddr = httpServletReq.getRemoteAddr();
        } else if (remoteAddr.indexOf(",") != -1) {
            remoteAddr = remoteAddr.split(",")[0].trim();
        }
        return remoteAddr;
    }

    private final void init() {
        String userAgent = this.getUserAgent() != null ? this.getUserAgent().toLowerCase() : "";
        boolean browserOpera = userAgent.indexOf("opera") != -1;
        boolean browserSafari = userAgent.indexOf("safari") != -1;
        boolean browserKonqueror = userAgent.indexOf("konqueror") != -1;
        boolean deceptiveUserAgent = browserOpera || browserSafari || browserKonqueror;
        boolean browserMozilla = !deceptiveUserAgent && userAgent.indexOf("gecko") != -1;
        boolean browserFireFox = userAgent.indexOf("firefox") != -1;
        boolean browserInternetExplorer = !deceptiveUserAgent && userAgent.indexOf("msie") != -1;
        int majorVersion = -1;
        int minorVersion = -1;
        if (browserOpera) {
            this.properties.setBrowserOpera(true);
        } else if (browserKonqueror) {
            this.properties.setBrowserKonqueror(true);
        } else if (browserSafari) {
            this.properties.setBrowserSafari(true);
        } else if (browserMozilla) {
            this.properties.setBrowserMozilla(true);
            if (browserFireFox) {
                this.properties.setBrowserMozillaFirefox(true);
            }
        } else if (browserInternetExplorer) {
            this.properties.setBrowserInternetExplorer(true);
            if (userAgent.indexOf("msie 6.") != -1) {
                majorVersion = 6;
            } else if (userAgent.indexOf("msie 7.") != -1) {
                majorVersion = 7;
            }
        }
        if (majorVersion != -1) {
            this.properties.setBrowserVersionMajor(majorVersion);
        }
        if (minorVersion != -1) {
            this.properties.setBrowserVersionMinor(minorVersion);
        }
        if (browserInternetExplorer) {
            this.properties.setProprietaryIECssExpressionsSupported(true);
            this.properties.setQuirkCssPositioningOneSideOnly(true);
            this.properties.setQuirkIERepaint(true);
            this.properties.setQuirkIESelectZIndex(true);
            this.properties.setQuirkIETextareaNewlineObliteration(true);
            this.properties.setQuirkIESelectPercentWidth(true);
            this.properties.setQuirkIESelectListDomUpdate(true);
            this.properties.setQuirkIETablePercentWidthScrollbarError(true);
            this.properties.setQuirkCssBackgroundAttachmentUseFixed(true);
            this.properties.setQuirkCssBorderCollapseInside(true);
            this.properties.setQuirkCssBorderCollapseFor0Padding(true);
            if (majorVersion < 7) {
                this.properties.setProprietaryIEPngAlphaFilterRequired(true);
            }
        }
        if (browserMozilla) {
            this.properties.setQuirkMozillaTextInputRepaint(true);
            this.properties.setQuirkMozillaPerformanceLargeDomRemove(true);
        }
        if (log.isDebugEnabled()) {
            log.debug("determined user agent: " + this.properties);
        }
    }
}

