/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.apache.wicket.protocol.http.MockHttpServletRequest;
import org.apache.wicket.protocol.http.RequestUtils;
import org.apache.wicket.util.value.ValueMap;

public class MockHttpServletResponse
implements HttpServletResponse {
    private static final int MODE_BINARY = 1;
    private static final int MODE_NONE = 0;
    private static final int MODE_TEXT = 2;
    private ByteArrayOutputStream byteStream;
    private String characterEncoding = "UTF-8";
    private int code = 200;
    private final List cookies = new ArrayList();
    private String errorMessage = null;
    private final ValueMap headers = new ValueMap();
    private Locale locale = null;
    private int mode = 0;
    private PrintWriter printWriter;
    private String redirectLocation = null;
    private ServletOutputStream servletStream;
    private int status = 200;
    private StringWriter stringWriter;
    private final MockHttpServletRequest servletRequest;
    private static String[] DAYS = new String[]{"Sat", "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static String[] MONTHS = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec", "Jan"};

    public MockHttpServletResponse(MockHttpServletRequest servletRequest) {
        this.servletRequest = servletRequest;
        this.initialize();
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public void addDateHeader(String name, long l) {
        DateFormat df = DateFormat.getDateInstance(0);
        this.addHeader(name, df.format(new Date(l)));
    }

    public void addHeader(String name, String value) {
        ArrayList<String> list = (ArrayList<String>)this.headers.get(name);
        if (list == null) {
            list = new ArrayList<String>(1);
            this.headers.put(name, list);
        }
        list.add(value);
    }

    public void addIntHeader(String name, int i) {
        this.addHeader(name, "" + i);
    }

    public boolean containsHeader(String name) {
        return this.headers.containsKey(name);
    }

    public String encodeRedirectUrl(String url) {
        return url;
    }

    public String encodeRedirectURL(String url) {
        return url;
    }

    public String encodeUrl(String url) {
        return url;
    }

    public String encodeURL(String url) {
        return url;
    }

    public void flushBuffer() throws IOException {
    }

    public byte[] getBinaryContent() {
        return this.byteStream.toByteArray();
    }

    public int getBufferSize() {
        if (this.mode == 0) {
            return 0;
        }
        if (this.mode == 1) {
            return this.byteStream.size();
        }
        return this.stringWriter.getBuffer().length();
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public int getCode() {
        return this.code;
    }

    public Collection getCookies() {
        return this.cookies;
    }

    public String getDocument() {
        if (this.mode == 1) {
            return new String(this.byteStream.toByteArray());
        }
        return this.stringWriter.getBuffer().toString();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getHeader(String name) {
        List l = (List)this.headers.get(name);
        if (l == null || l.size() < 1) {
            return null;
        }
        return (String)l.get(0);
    }

    public Set getHeaderNames() {
        return this.headers.keySet();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ServletOutputStream getOutputStream() {
        if (this.mode == 2) {
            throw new IllegalArgumentException("Can't write binary after already selecting text");
        }
        this.mode = 1;
        return this.servletStream;
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    public int getStatus() {
        return this.status;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.mode == 1) {
            throw new IllegalArgumentException("Can't write text after already selecting binary");
        }
        this.mode = 2;
        return this.printWriter;
    }

    public void initialize() {
        this.cookies.clear();
        this.headers.clear();
        this.code = 200;
        this.errorMessage = null;
        this.redirectLocation = null;
        this.status = 200;
        this.characterEncoding = "UTF-8";
        this.locale = null;
        this.byteStream = new ByteArrayOutputStream();
        this.servletStream = new ServletOutputStream(){

            public void write(int b) {
                MockHttpServletResponse.this.byteStream.write(b);
            }
        };
        this.stringWriter = new StringWriter();
        this.printWriter = new PrintWriter(this.stringWriter){

            public void close() {
            }

            public void flush() {
            }
        };
        this.mode = 0;
    }

    public boolean isCommitted() {
        return false;
    }

    public boolean isError() {
        return this.code != 200;
    }

    public boolean isRedirect() {
        return this.redirectLocation != null;
    }

    public void reset() {
        this.initialize();
    }

    public void resetBuffer() {
        if (this.mode == 1) {
            this.byteStream.reset();
        } else if (this.mode == 2) {
            this.stringWriter.getBuffer().delete(0, this.stringWriter.getBuffer().length());
        }
    }

    public void sendError(int code) throws IOException {
        this.code = code;
        this.errorMessage = null;
    }

    public void sendError(int code, String msg) throws IOException {
        this.code = code;
        this.errorMessage = msg;
    }

    private String getURL() {
        String queryString;
        String url = this.servletRequest.getServletPath();
        String pathInfo = this.servletRequest.getPathInfo();
        if (pathInfo != null) {
            url = url + pathInfo;
        }
        if ((queryString = this.servletRequest.getQueryString()) != null) {
            url = url + "?" + queryString;
        }
        if (url.length() > 0 && url.charAt(0) == '/') {
            url = url.substring(1);
        }
        return url;
    }

    public void sendRedirect(String location) throws IOException {
        String url;
        int index;
        if (location.startsWith("../") && (index = (url = this.getURL()).lastIndexOf("/")) != -1) {
            url = url.substring(0, index + 1) + location;
            url = RequestUtils.removeDoubleDots(url);
            index = url.indexOf("/");
            location = url.substring(index + 1);
        }
        this.redirectLocation = location;
    }

    public void setBufferSize(int size) {
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public void setContentLength(int length) {
        this.setIntHeader("Content-Length", length);
    }

    public void setContentType(String type) {
        this.setHeader("Content-Type", type);
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public void setDateHeader(String name, long l) {
        this.setHeader(name, MockHttpServletResponse.formatDate(l));
    }

    public static String formatDate(long l) {
        StringBuffer _dateBuffer = new StringBuffer(32);
        GregorianCalendar _calendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        _calendar.setTimeInMillis(l);
        MockHttpServletResponse.formatDate(_dateBuffer, _calendar, false);
        return _dateBuffer.toString();
    }

    public static void formatDate(StringBuffer buf, Calendar calendar, boolean cookie) {
        int day_of_week = calendar.get(7);
        int day_of_month = calendar.get(5);
        int month = calendar.get(2);
        int year = calendar.get(1);
        int century = year / 100;
        year %= 100;
        int epoch = (int)(calendar.getTimeInMillis() / 1000L % 86400L);
        int seconds = epoch % 60;
        int minutes = (epoch /= 60) % 60;
        int hours = epoch / 60;
        buf.append(DAYS[day_of_week]);
        buf.append(',');
        buf.append(' ');
        MockHttpServletResponse.append2digits(buf, day_of_month);
        if (cookie) {
            buf.append('-');
            buf.append(MONTHS[month]);
            buf.append('-');
            MockHttpServletResponse.append2digits(buf, year);
        } else {
            buf.append(' ');
            buf.append(MONTHS[month]);
            buf.append(' ');
            MockHttpServletResponse.append2digits(buf, century);
            MockHttpServletResponse.append2digits(buf, year);
        }
        buf.append(' ');
        MockHttpServletResponse.append2digits(buf, hours);
        buf.append(':');
        MockHttpServletResponse.append2digits(buf, minutes);
        buf.append(':');
        MockHttpServletResponse.append2digits(buf, seconds);
        buf.append(" GMT");
    }

    public static void append2digits(StringBuffer buf, int i) {
        if (i < 100) {
            buf.append((char)(i / 10 + 48));
            buf.append((char)(i % 10 + 48));
        }
    }

    public void setHeader(String name, String value) {
        ArrayList<String> l = new ArrayList<String>(1);
        l.add(value);
        this.headers.put(name, l);
    }

    public void setIntHeader(String name, int i) {
        this.setHeader(name, "" + i);
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setStatus(int status, String msg) {
        this.setStatus(status);
    }
}

