/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.resolver;

import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.parser.filter.WicketTagIdentifier;
import org.apache.wicket.markup.resolver.IComponentResolver;

public class MarkupInheritanceResolver
implements IComponentResolver {
    private static final long serialVersionUID = 1L;

    public boolean resolve(MarkupContainer container, MarkupStream markupStream, ComponentTag tag) {
        if (tag instanceof WicketTag) {
            WicketTag wicketTag = (WicketTag)tag;
            String id = wicketTag.getId() + container.getPage().getAutoIndex();
            if (wicketTag.isExtendTag()) {
                container.autoAdd(new TransparentWebMarkupContainer(id), markupStream);
                return true;
            }
            if (wicketTag.isChildTag()) {
                container.autoAdd(new TransparentWebMarkupContainer(id), markupStream);
                return true;
            }
        }
        return false;
    }

    static {
        WicketTagIdentifier.registerWellKnownTagName("extend");
        WicketTagIdentifier.registerWellKnownTagName("child");
    }

    private static class TransparentWebMarkupContainer
    extends WebMarkupContainer {
        private static final long serialVersionUID = 1L;

        public TransparentWebMarkupContainer(String id) {
            super(id);
        }

        public boolean isTransparentResolver() {
            return true;
        }
    }
}

