/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket;

import java.util.Map;
import org.apache.wicket.IResourceListener;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Response;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.request.target.resource.ResourceStreamRequestTarget;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.time.Time;
import org.apache.wicket.util.value.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Resource
implements IResourceListener {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger((Class)Resource.class);
    private boolean cacheable = true;
    private static final ThreadLocal parameters = new ThreadLocal();

    protected Resource() {
    }

    public abstract IResourceStream getResourceStream();

    public final boolean isCacheable() {
        return this.cacheable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onResourceRequested() {
        try {
            RequestCycle cycle = RequestCycle.get();
            IResourceStream resourceStream = this.init();
            Response response = cycle.getResponse();
            if (this.isCacheable()) {
                response.setLastModifiedTime(resourceStream.lastModifiedTime());
            } else {
                response.setLastModifiedTime(Time.valueOf(-1L));
            }
            this.configureResponse(response);
            cycle.setRequestTarget(new ResourceStreamRequestTarget(resourceStream));
        }
        finally {
            parameters.set(null);
        }
    }

    public final Resource setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
        return this;
    }

    public final void setParameters(Map parameters) {
        if (parameters == null) {
            Resource.parameters.set(null);
        } else {
            Resource.parameters.set(new ValueMap(parameters));
        }
    }

    protected void configureResponse(Response response) {
    }

    protected ValueMap getParameters() {
        if (parameters.get() == null) {
            return new ValueMap(RequestCycle.get().getRequest().getRequestParameters().getParameters());
        }
        return (ValueMap)parameters.get();
    }

    protected void invalidate() {
    }

    private final IResourceStream init() {
        IResourceStream stream = this.getResourceStream();
        if (stream == null) {
            throw new WicketRuntimeException("Could not get resource stream");
        }
        return stream;
    }
}

