/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.enhancer;

import java.net.URL;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.ClassNotResolvedException;

public final class EnhancerClassLoader
extends ClassLoader {
    ClassLoaderResolver delegate;
    boolean loadingClass = false;
    boolean loadingResource = false;

    public EnhancerClassLoader() {
        super(Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void defineClass(String fullClassName, byte[] bytes, ClassLoaderResolver clr) {
        this.delegate = clr;
        try {
            this.defineClass(fullClassName, bytes, 0, bytes.length);
        }
        finally {
            this.delegate = null;
        }
    }

    public synchronized Class loadClass(String name) throws ClassNotFoundException {
        if (this.loadingClass) {
            throw new ClassNotFoundException("Class " + name + " not found");
        }
        this.loadingClass = true;
        try {
            Class<?> clazz = super.loadClass(name);
            return clazz;
        }
        catch (ClassNotFoundException ex) {
            if (this.delegate != null) {
                try {
                    Class clazz = this.delegate.classForName(name);
                    return clazz;
                }
                catch (ClassNotResolvedException cnrex) {
                    throw new ClassNotFoundException(cnrex.toString(), cnrex);
                }
            }
            throw ex;
        }
        finally {
            this.loadingClass = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized URL findResource(String name) {
        if (this.loadingResource) {
            return null;
        }
        this.loadingResource = true;
        try {
            URL url = super.findResource(name);
            if (url == null && this.delegate != null) {
                url = this.delegate.getResource(name, null);
            }
            URL uRL = url;
            return uRL;
        }
        finally {
            this.loadingResource = false;
        }
    }
}

