/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base.genfiles;

import com.google.appengine.repackaged.com.google.common.base.X;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringStringMap
implements Iterable<Entry> {
    private static final String EMPTY_KEY = null;
    private static final String DELETED_KEY = new String();
    private String[] table;
    private String[] value;
    private int count;
    private int bits1;
    private int bits2;
    private int enlarge_threshold;
    private int lookups;
    private int probes;
    private int deleted;
    private int shrink_threshold;
    private static final float MAX_OCCUPANCY = 0.8f;
    private static final float MIN_OCCUPANCY = 0.1f;
    private static String[] empty_table = new String[0];
    private long last_stats = System.currentTimeMillis();
    private final boolean silent_;

    public StringStringMap() {
        this(4);
    }

    public StringStringMap(int n) {
        this(n, false);
    }

    public StringStringMap(int n, boolean silent) {
        this.silent_ = silent;
        this.table = empty_table;
        this.resize(Math.max(3, n));
    }

    public void insert(String key, String val) {
        int index = this.find_index(key);
        String old_elem = this.table[index];
        this.table[index] = key;
        this.value[index] = val;
        if (old_elem == EMPTY_KEY) {
            ++this.count;
            if (this.count + this.deleted >= this.enlarge_threshold) {
                this.resize(this.count * 2);
            }
        } else if (old_elem == DELETED_KEY) {
            ++this.count;
            --this.deleted;
        }
    }

    public boolean contains(String key) {
        String elem = this.table[this.find_index(key)];
        return elem != EMPTY_KEY && elem != DELETED_KEY;
    }

    public String lookup(String key, String default_value) {
        int index = this.find_index(key);
        String k = this.table[index];
        if (k == EMPTY_KEY || k == DELETED_KEY) {
            return default_value;
        }
        return this.value[index];
    }

    public boolean remove(String key) {
        int index = this.find_index(key);
        String elem = this.table[index];
        if (elem == EMPTY_KEY || elem == DELETED_KEY) {
            return false;
        }
        this.table[index] = DELETED_KEY;
        this.value[index] = null;
        --this.count;
        ++this.deleted;
        if (this.count < this.shrink_threshold) {
            this.resize(this.count);
        }
        return true;
    }

    public int size() {
        return this.count;
    }

    public int next(int i) {
        ++i;
        while (i < this.table.length) {
            String key = this.table[i];
            if (key != EMPTY_KEY && key != DELETED_KEY) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Iterator<String> keyIterator() {
        return new HashIterator<String>(this){

            @Override
            public String next() {
                return this.map.keyAt(this.nextIndex());
            }
        };
    }

    public Iterator<String> valueIterator() {
        return new HashIterator<String>(this){

            @Override
            public String next() {
                return this.map.valueAt(this.nextIndex());
            }
        };
    }

    @Override
    public Iterator<Entry> iterator() {
        return new HashIterator<Entry>(this){

            @Override
            public Entry next() {
                int next = this.nextIndex();
                return new Entry(this.map.keyAt(next), this.map.valueAt(next));
            }
        };
    }

    public String[] toValueArray() {
        String[] array = new String[this.size()];
        int arrayIndex = 0;
        int mapIndex = -1;
        while ((mapIndex = this.next(mapIndex)) >= 0 && arrayIndex < array.length) {
            array[arrayIndex++] = this.valueAt(mapIndex);
        }
        return array;
    }

    public String keyAt(int i) {
        return this.table[i];
    }

    public String valueAt(int i) {
        return this.value[i];
    }

    public void setValueAt(int i, String v) {
        this.value[i] = v;
    }

    public void removeAt(int i) {
        X.assertTrue(this.table[i] != DELETED_KEY);
        X.assertTrue(this.table[i] != EMPTY_KEY);
        this.table[i] = DELETED_KEY;
        --this.count;
        ++this.deleted;
    }

    private int find_index(String key) {
        ++this.lookups;
        int n = this.table.length;
        int mult = key.hashCode() * -820265764 & Integer.MAX_VALUE;
        int h1 = mult >>> this.bits1 & n - 1;
        int h2 = mult >>> this.bits2 & n - 1 | 1;
        int index = h1;
        int deleted_index = -1;
        for (int i = 0; i < n; ++i) {
            ++this.probes;
            if (this.table[index] == DELETED_KEY) {
                if (deleted_index < 0) {
                    deleted_index = index;
                }
            } else {
                if (this.table[index] == EMPTY_KEY) {
                    return deleted_index >= 0 ? deleted_index : index;
                }
                if (key.equals(this.table[index])) {
                    return index;
                }
            }
            index = index + h2 & n - 1;
        }
        throw new RuntimeException("Did not find empty slot for " + key);
    }

    public void resize(int desired) {
        if (desired < this.count) {
            desired = this.count;
        }
        int min_size = (int)((float)desired / 0.8f);
        int lg = 2;
        while (1 << lg < min_size) {
            ++lg;
        }
        int n = 1 << lg;
        if (n == this.count) {
            return;
        }
        String[] old = this.table;
        this.table = new String[n];
        String[] oldval = this.value;
        this.value = new String[n];
        this.enlarge_threshold = Math.min(n - 1, (int)((float)n * 0.8f));
        X.assertTrue(this.enlarge_threshold < n);
        this.count = 0;
        this.bits2 = Math.max(31 - 2 * lg, 0);
        this.bits1 = 31 - lg;
        this.shrink_threshold = (int)((float)n * 0.1f);
        if (this.shrink_threshold <= 10) {
            this.shrink_threshold = 1;
        }
        this.deleted = 0;
        X.assertTrue(this.shrink_threshold < this.enlarge_threshold);
        X.assertTrue(this.shrink_threshold >= 0);
        for (int i = 0; i < old.length; ++i) {
            String elem = old[i];
            if (elem == EMPTY_KEY || elem == DELETED_KEY) continue;
            this.insert(elem, oldval[i]);
        }
        if (!(this.table.length < 131072 && old.length < 131072 || this.silent_)) {
            this.stats("resize");
        }
    }

    public void stats(String label) {
        long now = System.currentTimeMillis();
        System.err.println((double)(now - this.last_stats) / 1000.0 + " " + label + " " + this.count + " cnt; " + this.table.length + " sz; " + this.enlarge_threshold + " th; " + this.lookups + "/" + this.probes);
        this.last_stats = now;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class HashIterator<E>
    implements Iterator<E> {
        private int nextIndex;
        private int currentIndex;
        StringStringMap map;

        private HashIterator(StringStringMap map) {
            this.map = map;
            this.nextIndex = map.next(-1);
            this.currentIndex = -1;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        int nextIndex() {
            this.currentIndex = this.nextIndex;
            this.nextIndex = this.map.next(this.currentIndex);
            return this.currentIndex;
        }

        @Override
        public void remove() {
            if (this.currentIndex < 0) {
                throw new IllegalStateException();
            }
            this.map.removeAt(this.currentIndex);
            this.nextIndex = this.map.next(this.currentIndex);
            this.currentIndex = -1;
        }
    }

    public static class Entry {
        private final String key;
        private final String value;

        public Entry(String k, String v) {
            this.key = k;
            this.value = v;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

