/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped.scostore;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.mapped.DatastoreContainerObject;
import org.datanucleus.store.mapped.DatastoreIdentifier;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.exceptions.MappedDatastoreException;
import org.datanucleus.store.mapped.expression.LogicSetExpression;
import org.datanucleus.store.mapped.expression.QueryExpression;
import org.datanucleus.store.mapped.expression.ScalarExpression;
import org.datanucleus.store.mapped.mapping.EmbeddedKeyPCMapping;
import org.datanucleus.store.mapped.mapping.EmbeddedValuePCMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.MappingHelper;
import org.datanucleus.store.mapped.mapping.SerialisedPCMapping;
import org.datanucleus.store.mapped.mapping.SerialisedReferenceMapping;
import org.datanucleus.store.mapped.scostore.BaseContainerStore;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.store.scostore.MapStore;
import org.datanucleus.store.scostore.SetStore;

public abstract class MapEntrySetStore
extends BaseContainerStore
implements SetStore {
    protected DatastoreContainerObject setTable;
    protected MapStore mapStore;
    protected JavaTypeMapping keyMapping;
    protected JavaTypeMapping valueMapping;
    protected String keyType;
    protected String valueType;
    protected AbstractClassMetaData kmd;
    protected AbstractClassMetaData vmd;
    protected ClassLoaderResolver clr;

    public MapEntrySetStore(DatastoreContainerObject mapTable, JavaTypeMapping ownerMapping, AbstractMemberMetaData ownerMemberMetaData, JavaTypeMapping keyMapping, JavaTypeMapping valueMapping, MapStore mapStore, ClassLoaderResolver clr, MappedStoreManager storeMgr) {
        super(mapTable.getStoreManager());
        this.setTable = mapTable;
        this.mapStore = mapStore;
        this.keyType = mapStore.getKeyType();
        this.valueType = mapStore.getValueType();
        this.ownerMapping = ownerMapping;
        this.ownerMemberMetaData = ownerMemberMetaData;
        this.keyMapping = keyMapping;
        this.valueMapping = valueMapping;
        this.kmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(this.keyType, clr);
        this.vmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(this.valueType, clr);
        this.clr = clr;
    }

    public MapEntrySetStore(DatastoreContainerObject valueTable, JavaTypeMapping ownerMapping, JavaTypeMapping keyMapping, JavaTypeMapping valueMapping, MapStore mapStore) {
        super(valueTable.getStoreManager());
        this.setTable = valueTable;
        this.mapStore = mapStore;
        this.keyType = mapStore.getKeyType();
        this.valueType = mapStore.getValueType();
        this.ownerMapping = ownerMapping;
        this.keyMapping = keyMapping;
        this.valueMapping = valueMapping;
    }

    public boolean hasOrderMapping() {
        return false;
    }

    public boolean updateEmbeddedElement(StateManager sm, Object element, int fieldNumber, Object value) {
        return false;
    }

    public String getElementType() {
        return EntryImpl.class.getName();
    }

    public JavaTypeMapping getOwnerMapping() {
        return this.ownerMapping;
    }

    protected boolean validateElementType(Object element) {
        return element instanceof Map.Entry;
    }

    public abstract Iterator iterator(StateManager var1);

    public abstract int size(StateManager var1);

    public void update(StateManager sm, Collection coll) {
        this.clear(sm);
        this.addAll(sm, coll, 0);
    }

    public boolean contains(StateManager sm, Object element) {
        if (!this.validateElementType(element)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)element;
        return this.mapStore.containsKey(sm, entry.getKey());
    }

    public boolean add(StateManager sm, Object element, int size) {
        throw new UnsupportedOperationException("Cannot add to a map through its entry set");
    }

    public boolean addAll(StateManager sm, Collection elements, int size) {
        throw new UnsupportedOperationException("Cannot add to a map through its entry set");
    }

    public boolean remove(StateManager sm, Object element, int size, boolean allowDependentField) {
        if (!this.validateElementType(element)) {
            return false;
        }
        Map.Entry entry = (Map.Entry)element;
        Object removed = this.mapStore.remove(sm, entry.getKey());
        return removed == null ? entry.getValue() == null : removed.equals(entry.getValue());
    }

    public boolean removeAll(StateManager sm, Collection elements, int size) {
        if (elements == null || elements.size() == 0) {
            return false;
        }
        Iterator iter = elements.iterator();
        boolean modified = false;
        while (iter.hasNext()) {
            Object element = iter.next();
            Map.Entry entry = (Map.Entry)element;
            Object removed = this.mapStore.remove(sm, entry.getKey());
            modified = removed == null ? entry.getValue() == null : removed.equals(entry.getValue());
        }
        return modified;
    }

    public void clear(StateManager sm) {
        this.mapStore.clear(sm);
    }

    public ResultObjectFactory newResultObjectFactory(StateManager sm, QueryExpression stmt, boolean ignoreCache, boolean useFetchPlan) {
        throw new NucleusUserException("Cannot query sets obtained by Map.entrySet()");
    }

    public QueryExpression getExistsSubquery(QueryExpression stmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier collectionTableAlias) {
        throw new NucleusUserException("Cannot query sets obtained by Map.entrySet()");
    }

    public QueryExpression getSizeSubquery(QueryExpression stmt, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier collectionTableAlias) {
        throw new NucleusUserException("Cannot query sets obtained by Map.entrySet()");
    }

    public ScalarExpression joinElementsTo(QueryExpression stmt, QueryExpression qs, JavaTypeMapping ownerMapping, LogicSetExpression ownerTe, DatastoreIdentifier collectionTableAlias, Class filteredElementType, ScalarExpression elmExpr, DatastoreIdentifier elementTableAlias, boolean existsQuery) {
        throw new NucleusUserException("Cannot query sets obtained by Map.entrySet()");
    }

    public MapStore getMapStore() {
        return this.mapStore;
    }

    public JavaTypeMapping getKeyMapping() {
        return this.keyMapping;
    }

    public JavaTypeMapping getValueMapping() {
        return this.valueMapping;
    }

    public DatastoreContainerObject getSetTable() {
        return this.setTable;
    }

    private static class EntryImpl
    implements Map.Entry {
        private final StateManager sm;
        private final Object key;
        private final Object value;
        private final MapStore mapStore;

        public EntryImpl(StateManager sm, Object key, Object value, MapStore mapStore) {
            this.sm = sm;
            this.key = key;
            this.value = value;
            this.mapStore = mapStore;
        }

        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (this.key == null ? e.getKey() == null : this.key.equals(e.getKey())) && (this.value == null ? e.getValue() == null : this.value.equals(e.getValue()));
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            return this.mapStore.put(this.sm, this.key, value);
        }
    }

    public static abstract class SetIterator
    implements Iterator {
        private final StateManager sm;
        private final ObjectManager om;
        private final Iterator delegate;
        private Map.Entry lastElement = null;
        private final MapEntrySetStore setStore;

        protected SetIterator(StateManager sm, MapEntrySetStore setStore, AbstractMemberMetaData ownerMemberMetaData, Object rs) throws MappedDatastoreException {
            this.sm = sm;
            this.om = sm.getObjectManager();
            this.setStore = setStore;
            ArrayList<EntryImpl> results = new ArrayList<EntryImpl>();
            while (this.next(rs)) {
                JavaTypeMapping keyMapping;
                int jdbcPosition = 1;
                Object key = null;
                Object value = null;
                int ownerFieldNum = -1;
                if (ownerMemberMetaData != null) {
                    ownerFieldNum = ownerMemberMetaData.getAbsoluteFieldNumber();
                }
                key = (keyMapping = setStore.getKeyMapping()) instanceof EmbeddedKeyPCMapping || keyMapping instanceof SerialisedPCMapping || keyMapping instanceof SerialisedReferenceMapping ? keyMapping.getObject(this.om, rs, MappingHelper.getMappingIndices(jdbcPosition, keyMapping), sm, ownerFieldNum) : keyMapping.getObject(this.om, rs, MappingHelper.getMappingIndices(jdbcPosition, keyMapping));
                JavaTypeMapping valueMapping = setStore.getValueMapping();
                value = valueMapping instanceof EmbeddedValuePCMapping || valueMapping instanceof SerialisedPCMapping || valueMapping instanceof SerialisedReferenceMapping ? valueMapping.getObject(this.om, rs, MappingHelper.getMappingIndices(jdbcPosition, valueMapping), sm, ownerFieldNum) : valueMapping.getObject(this.om, rs, MappingHelper.getMappingIndices(jdbcPosition += keyMapping.getNumberOfDatastoreFields(), valueMapping));
                results.add(new EntryImpl(sm, key, value, setStore.getMapStore()));
            }
            this.delegate = results.iterator();
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public Object next() {
            this.lastElement = (Map.Entry)this.delegate.next();
            return this.lastElement;
        }

        public synchronized void remove() {
            if (this.lastElement == null) {
                throw new IllegalStateException("No entry to remove");
            }
            this.setStore.getMapStore().remove(this.sm, this.lastElement.getKey());
            this.delegate.remove();
            this.lastElement = null;
        }

        protected abstract boolean next(Object var1) throws MappedDatastoreException;
    }
}

