/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.mapped;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.util.StringUtils;

public class StatementMappingIndex {
    JavaTypeMapping mapping;
    int[] columnPositions;
    List<int[]> paramPositions = null;
    String columnName;

    public StatementMappingIndex(JavaTypeMapping mapping) {
        this.mapping = mapping;
    }

    public JavaTypeMapping getMapping() {
        return this.mapping;
    }

    public String getColumnAlias() {
        if (this.columnName != null) {
            return this.columnName;
        }
        if (this.mapping != null && this.mapping.getMemberMetaData() != null) {
            return this.mapping.getMemberMetaData().getName();
        }
        return null;
    }

    public void setColumnAlias(String alias) {
        this.columnName = alias;
    }

    public int[] getColumnPositions() {
        return this.columnPositions;
    }

    public void setColumnPositions(int[] pos) {
        this.columnPositions = pos;
    }

    public void addParameterOccurrence(int[] positions) {
        if (this.paramPositions == null) {
            this.paramPositions = new ArrayList<int[]>();
        }
        if (this.mapping != null && positions.length != this.mapping.getNumberOfDatastoreFields()) {
            throw new NucleusException("Mapping " + this.mapping + " cannot be " + positions.length + " parameters since it has " + this.mapping.getNumberOfDatastoreFields() + " columns");
        }
        this.paramPositions.add(positions);
    }

    public int getNumberOfParameterOccurrences() {
        return this.paramPositions != null ? this.paramPositions.size() : 0;
    }

    public int[] getParameterPositionsForOccurrence(int num) {
        if (this.paramPositions == null) {
            return null;
        }
        return this.paramPositions.get(num);
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("mapping: " + this.mapping);
        if (this.paramPositions != null) {
            str.append(" parameter(s): ");
            Iterator<int[]> iter = this.paramPositions.iterator();
            while (iter.hasNext()) {
                int[] positions = iter.next();
                str.append(StringUtils.intArrayToString(positions));
                if (!iter.hasNext()) continue;
                str.append(',');
            }
        }
        if (this.columnPositions != null) {
            str.append(" column(s): " + StringUtils.intArrayToString(this.columnPositions));
        }
        return str.toString();
    }
}

