/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.pagestore;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.Page;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.pagestore.AbstractPageStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSynchronousFilePageStore
extends AbstractPageStore {
    private final File defaultWorkDir;
    private final String appName;
    private static final Logger log = LoggerFactory.getLogger((Class)SimpleSynchronousFilePageStore.class);

    public SimpleSynchronousFilePageStore(File workDir) {
        this.defaultWorkDir = workDir;
        this.defaultWorkDir.mkdirs();
        this.appName = Application.get().getApplicationKey();
    }

    public SimpleSynchronousFilePageStore() {
        this((File)((WebApplication)Application.get()).getServletContext().getAttribute("javax.servlet.context.tempdir"));
    }

    private String getFileName(String pageMapName, int pageId) {
        return this.appName + "-pm-" + pageMapName + "-p-" + pageId;
    }

    private void sortFiles(File[] files) {
        Arrays.sort(files, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                File f1 = (File)arg0;
                File f2 = (File)arg1;
                return f1.lastModified() < f2.lastModified() ? -1 : (f1.lastModified() == f2.lastModified() ? 0 : 1);
            }
        });
    }

    private File getPageFile(File sessionDir, String pageMapName, int pageId, int versionNumber, int ajaxVersionNumber) {
        final String fileNamePrefix = this.getFileName(pageMapName, pageId);
        if (versionNumber != -1 && ajaxVersionNumber != -1) {
            return new File(sessionDir, fileNamePrefix + "-v-" + versionNumber + "-a-" + ajaxVersionNumber);
        }
        if (versionNumber == -1) {
            File[] files = sessionDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith(fileNamePrefix);
                }
            });
            if (files == null || files.length == 0) {
                return null;
            }
            this.sortFiles(files);
            return files[files.length - 1];
        }
        final String prefixWithVersion = fileNamePrefix + "-v-" + versionNumber;
        File[] files = sessionDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(prefixWithVersion);
            }
        });
        if (files == null || files.length == 0) {
            return null;
        }
        int lastAjaxVersion = -1;
        int indexWithBiggestAjaxVersion = -1;
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String ajaxVersionString = file.getName().substring(file.getName().lastIndexOf(45) + 1);
            int ajaxVersion = Integer.parseInt(ajaxVersionString);
            if (lastAjaxVersion >= ajaxVersion) continue;
            lastAjaxVersion = ajaxVersion;
            indexWithBiggestAjaxVersion = i;
        }
        return files[indexWithBiggestAjaxVersion];
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected byte[] loadPageData(File workDir, String sessionId, String pageMapName, int pageId, int versionNumber, int ajaxVersionNumber) {
        byte[] pageData;
        block14: {
            File pageFile;
            File sessionDir = new File(workDir, sessionId);
            pageData = null;
            if (sessionDir.exists() && (pageFile = this.getPageFile(sessionDir, pageMapName, pageId, versionNumber, ajaxVersionNumber)).exists()) {
                FileInputStream fis;
                block13: {
                    fis = null;
                    fis = new FileInputStream(pageFile);
                    int length = (int)pageFile.length();
                    ByteBuffer bb = ByteBuffer.allocate(length);
                    fis.getChannel().read(bb);
                    if (bb.hasArray()) {
                        pageData = bb.array();
                        break block13;
                    }
                    pageData = new byte[length];
                    bb.get(pageData);
                }
                Object var14_14 = null;
                try {
                    if (fis != null) {
                        fis.close();
                    }
                    break block14;
                }
                catch (IOException ex) {}
                break block14;
                {
                    catch (Exception e) {
                        log.debug("Error loading page " + pageId + "," + versionNumber + " for the sessionid " + sessionId + " from disk", (Throwable)e);
                        Object var14_15 = null;
                        try {
                            if (fis != null) {
                                fis.close();
                            }
                            break block14;
                        }
                        catch (IOException ex) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var14_16 = null;
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        return pageData;
    }

    public Page getPage(String sessionId, String pageMapName, int pageId, int versionNumber, int ajaxVersionNumber) {
        byte[] data = this.loadPageData(this.defaultWorkDir, sessionId, pageMapName, pageId, versionNumber, ajaxVersionNumber);
        if (data != null) {
            return this.deserializePage(data, versionNumber);
        }
        return null;
    }

    public void pageAccessed(String sessionId, Page page) {
    }

    private void removeFiles(String sessionId, String pageMap, int id) {
        File sessionDir = new File(this.defaultWorkDir, sessionId);
        if (sessionDir.exists()) {
            final String filepart = id != -1 ? this.appName + "-pm-" + pageMap + "-p-" + id : this.appName + "-pm-" + pageMap;
            File[] listFiles = sessionDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith(filepart);
                }
            });
            for (int i = 0; i < listFiles.length; ++i) {
                listFiles[i].delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected long savePageData(String sessionId, AbstractPageStore.SerializedPage page) {
        int length;
        block11: {
            File sessionDir = new File(this.defaultWorkDir, sessionId);
            sessionDir.mkdirs();
            File pageFile = this.getPageFile(sessionDir, page.getPageMapName(), page.getPageId(), page.getVersionNumber(), page.getAjaxVersionNumber());
            FileOutputStream fos = null;
            length = 0;
            fos = new FileOutputStream(pageFile);
            ByteBuffer bb = ByteBuffer.wrap(page.getData());
            fos.getChannel().write(bb);
            length = page.getData().length;
            Object var9_9 = null;
            try {
                if (fos != null) {
                    fos.close();
                }
                break block11;
            }
            catch (IOException ex) {}
            break block11;
            {
                catch (Exception e) {
                    log.error("Error saving page " + pageFile.getAbsolutePath());
                    Object var9_10 = null;
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                        break block11;
                    }
                    catch (IOException ex) {}
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return length;
    }

    public void removePage(String sessionId, String pageMapName, int pageId) {
        this.removeFiles(sessionId, pageMapName, pageId);
    }

    public void storePage(String sessionId, Page page) {
        List serialized = this.serializePage(page);
        Iterator i = serialized.iterator();
        while (i.hasNext()) {
            AbstractPageStore.SerializedPage serializedPage = (AbstractPageStore.SerializedPage)i.next();
            this.savePageData(sessionId, serializedPage);
        }
    }

    private void removeSession(String sessionId) {
        File sessionDir = new File(this.defaultWorkDir, sessionId);
        if (sessionDir.exists()) {
            File[] files = sessionDir.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    files[i].delete();
                }
            }
            if (!sessionDir.delete()) {
                sessionDir.deleteOnExit();
            }
        }
    }

    public void unbind(String sessionId) {
        this.removeSession(sessionId);
    }

    public boolean containsPage(String sessionId, String pageMapName, int pageId, int pageVersion) {
        File sessionDir = new File(this.defaultWorkDir, sessionId);
        File pageFile = this.getPageFile(sessionDir, pageMapName, pageId, pageVersion, -1);
        return pageFile.exists();
    }
}

