/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.event;

import java.util.ArrayList;
import javax.event.AfterTransactionCompletion;
import javax.event.AfterTransactionFailure;
import javax.event.AfterTransactionSuccess;
import javax.event.Asynchronously;
import javax.event.BeforeTransactionCompletion;
import javax.inject.DefinitionException;
import javax.inject.manager.Bean;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.event.AsynchronousTransactionalEventNotification;
import org.jboss.webbeans.event.DeferredEventNotification;
import org.jboss.webbeans.event.ObserverImpl;
import org.jboss.webbeans.event.TransactionSynchronizedRunnable;
import org.jboss.webbeans.introspector.AnnotatedMethod;
import org.jboss.webbeans.transaction.spi.TransactionServices;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TransactionalObserverImpl<T>
extends ObserverImpl<T> {
    private TransactionObservationPhase transactionObservationPhase;

    public static boolean isObserverMethodTransactional(AnnotatedMethod<?> observer) {
        boolean transactional = true;
        if (observer.getAnnotatedParameters(BeforeTransactionCompletion.class).isEmpty() && observer.getAnnotatedParameters(AfterTransactionCompletion.class).isEmpty() && observer.getAnnotatedParameters(AfterTransactionSuccess.class).isEmpty() && observer.getAnnotatedParameters(AfterTransactionFailure.class).isEmpty()) {
            transactional = false;
        }
        return transactional;
    }

    protected TransactionalObserverImpl(AnnotatedMethod<?> observer, Bean<?> observerBean, ManagerImpl manager) {
        super(observer, observerBean, manager);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.initTransactionObservationPhase();
    }

    @Override
    public void notify(T event) {
        if (this.manager.getServices().get(TransactionServices.class) != null && this.manager.getServices().get(TransactionServices.class).isTransactionActive()) {
            this.deferEvent(event);
        } else {
            this.sendEvent(event);
        }
    }

    private void initTransactionObservationPhase() {
        ArrayList<TransactionObservationPhase> observationPhases = new ArrayList<TransactionObservationPhase>();
        if (!this.observerMethod.getAnnotatedParameters(BeforeTransactionCompletion.class).isEmpty()) {
            observationPhases.add(TransactionObservationPhase.BEFORE_COMPLETION);
            if (!this.observerMethod.getAnnotatedParameters(Asynchronously.class).isEmpty()) {
                throw new DefinitionException("@BeforeTransactionCompletion cannot be used with @Asynchronously on " + this.observerMethod);
            }
        }
        if (!this.observerMethod.getAnnotatedParameters(AfterTransactionCompletion.class).isEmpty()) {
            observationPhases.add(TransactionObservationPhase.AFTER_COMPLETION);
        }
        if (!this.observerMethod.getAnnotatedParameters(AfterTransactionFailure.class).isEmpty()) {
            observationPhases.add(TransactionObservationPhase.AFTER_FAILURE);
        }
        if (!this.observerMethod.getAnnotatedParameters(AfterTransactionSuccess.class).isEmpty()) {
            observationPhases.add(TransactionObservationPhase.AFTER_SUCCESS);
        }
        if (observationPhases.size() > 1) {
            throw new DefinitionException("Transactional observers can only observe on a single phase: " + this.observerMethod);
        }
        if (observationPhases.size() != 1) {
            throw new IllegalStateException("This observer method is not transactional: " + this.observerMethod);
        }
        this.transactionObservationPhase = (TransactionObservationPhase)((Object)observationPhases.iterator().next());
    }

    private void deferEvent(T event) {
        DeferredEventNotification<T> deferredEvent = null;
        deferredEvent = this.observerMethod.getAnnotatedParameters(Asynchronously.class).isEmpty() ? new DeferredEventNotification<T>(event, this) : new AsynchronousTransactionalEventNotification<T>(event, this);
        TransactionSynchronizedRunnable synchronization = null;
        if (this.transactionObservationPhase.equals((Object)TransactionObservationPhase.BEFORE_COMPLETION)) {
            synchronization = new TransactionSynchronizedRunnable(deferredEvent, true);
        } else if (this.transactionObservationPhase.equals((Object)TransactionObservationPhase.AFTER_COMPLETION)) {
            synchronization = new TransactionSynchronizedRunnable(deferredEvent, false);
        } else if (this.transactionObservationPhase.equals((Object)TransactionObservationPhase.AFTER_SUCCESS)) {
            synchronization = new TransactionSynchronizedRunnable(deferredEvent, TransactionServices.Status.SUCCESS);
        } else if (this.transactionObservationPhase.equals((Object)TransactionObservationPhase.AFTER_FAILURE)) {
            synchronization = new TransactionSynchronizedRunnable(deferredEvent, TransactionServices.Status.FAILURE);
        }
        this.manager.getServices().get(TransactionServices.class).registerSynchronization(synchronization);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum TransactionObservationPhase {
        BEFORE_COMPLETION,
        AFTER_COMPLETION,
        AFTER_FAILURE,
        AFTER_SUCCESS;

    }
}

