/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config;

import com.google.appengine.repackaged.com.google.common.base.Objects;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;

public class ApiConfigInconsistency<T> {
    private String propertyName;
    private T value1;
    private T value2;

    public ApiConfigInconsistency(String propertyName, T value1, T value2) {
        this.propertyName = propertyName;
        this.value1 = value1;
        this.value2 = value2;
    }

    public String toString() {
        return String.format("Inconsistency: %s (%s vs %s)", this.propertyName, this.value1, this.value2);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ApiConfigInconsistency) {
            ApiConfigInconsistency inconsistency = (ApiConfigInconsistency)other;
            return this.propertyName.equals(inconsistency.propertyName) && this.value1.equals(inconsistency.value1) && this.value2.equals(inconsistency.value2);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.propertyName, this.value1, this.value2});
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public T getValue1() {
        return this.value1;
    }

    public T getValue2() {
        return this.value2;
    }

    public static <T> ListBuilder<T> listBuilder() {
        return new ListBuilder();
    }

    public static class ListBuilder<T> {
        private ImmutableList.Builder<ApiConfigInconsistency<T>> builder;

        private ListBuilder() {
        }

        private void createBuilderIfNecessary() {
            if (this.builder == null) {
                this.builder = ImmutableList.builder();
            }
        }

        public <T1 extends T> ListBuilder<T> addIfInconsistent(String propertyName, T1 value1, T1 value2) {
            if (!Objects.equal(value1, value2)) {
                this.createBuilderIfNecessary();
                this.builder.add(new ApiConfigInconsistency<T1>(propertyName, value1, value2));
            }
            return this;
        }

        public <T1 extends T> ListBuilder<T> addAll(Iterable<ApiConfigInconsistency<T1>> inconsistencies) {
            if (!Iterables.isEmpty(inconsistencies)) {
                this.createBuilderIfNecessary();
                this.builder.addAll(inconsistencies);
            }
            return this;
        }

        public ImmutableList<ApiConfigInconsistency<T>> build() {
            if (this.builder == null) {
                return ImmutableList.of();
            }
            return this.builder.build();
        }
    }
}

