/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi;

import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.repackaged.com.google.common.base.Splitter;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;

public class ServletInitializationParameters {
    private static final String INIT_PARAM_NAME_SERVICES = "services";
    private static final String INIT_PARAM_NAME_RESTRICTED = "restricted";
    private static final String INIT_PARAM_NAME_CLIENT_ID_WHITELIST_ENABLED = "clientIdWhitelistEnabled";
    private static final Splitter CSV_SPLITTER = Splitter.on((char)',').omitEmptyStrings().trimResults();
    private static final Joiner CSV_JOINER = Joiner.on((char)',').skipNulls();
    private static final Function<Class<?>, String> CLASS_TO_NAME = new Function<Class<?>, String>(){

        public String apply(Class<?> clazz) {
            return clazz.getName();
        }
    };
    private ImmutableSet<Class<?>> serviceClasses;
    private boolean isServletRestricted;
    private boolean isClientIdWhitelistEnabled;

    public static Builder builder() {
        return new Builder();
    }

    public static ServletInitializationParameters fromServletConfig(ServletConfig config, ClassLoader classLoader) throws ServletException {
        Builder builder = ServletInitializationParameters.builder();
        if (config != null) {
            String isClientIdWhitelistEnabled;
            String isServletRestricted;
            String serviceClassNames = config.getInitParameter(INIT_PARAM_NAME_SERVICES);
            if (serviceClassNames != null) {
                for (String serviceClassName : CSV_SPLITTER.split((CharSequence)serviceClassNames)) {
                    builder.addServiceClass(ServletInitializationParameters.getClassForName(serviceClassName, classLoader));
                }
            }
            if ((isServletRestricted = config.getInitParameter(INIT_PARAM_NAME_RESTRICTED)) != null) {
                builder.setRestricted(ServletInitializationParameters.parseBoolean(isServletRestricted, "is servlet restricted"));
            }
            if ((isClientIdWhitelistEnabled = config.getInitParameter(INIT_PARAM_NAME_CLIENT_ID_WHITELIST_ENABLED)) != null) {
                builder.setClientIdWhitelistEnabled(ServletInitializationParameters.parseBoolean(isClientIdWhitelistEnabled, "is the client id whitelist enabled"));
            }
        }
        return builder.build();
    }

    private static boolean parseBoolean(String booleanString, String descriptionForErrors) {
        if ("true".equalsIgnoreCase(booleanString)) {
            return true;
        }
        if ("false".equalsIgnoreCase(booleanString)) {
            return false;
        }
        throw new IllegalArgumentException(String.format("Expected 'true' or 'false' for %s servlet initialization parameter but got '%s'", descriptionForErrors, booleanString));
    }

    private static Class<?> getClassForName(String className, ClassLoader classLoader) throws ServletException {
        try {
            return Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new ServletException(String.format("Cannot find service class: %s", className), (Throwable)e);
        }
    }

    public ImmutableSet<Class<?>> getServiceClasses() {
        return this.serviceClasses;
    }

    public boolean isServletRestricted() {
        return this.isServletRestricted;
    }

    public boolean isClientIdWhitelistEnabled() {
        return this.isClientIdWhitelistEnabled;
    }

    public ImmutableMap<String, String> asMap() {
        ImmutableMap.Builder parameterNameToValue = ImmutableMap.builder();
        parameterNameToValue.put((Object)INIT_PARAM_NAME_SERVICES, (Object)CSV_JOINER.join(Iterables.transform(this.serviceClasses, CLASS_TO_NAME)));
        parameterNameToValue.put((Object)INIT_PARAM_NAME_RESTRICTED, (Object)Boolean.toString(this.isServletRestricted));
        parameterNameToValue.put((Object)INIT_PARAM_NAME_CLIENT_ID_WHITELIST_ENABLED, (Object)Boolean.toString(this.isClientIdWhitelistEnabled));
        return parameterNameToValue.build();
    }

    private ServletInitializationParameters(ImmutableSet<Class<?>> serviceClasses, boolean isServletRestricted, boolean isClientIdWhitelistEnabled) {
        this.serviceClasses = serviceClasses;
        this.isServletRestricted = isServletRestricted;
        this.isClientIdWhitelistEnabled = isClientIdWhitelistEnabled;
    }

    public static class Builder {
        private ImmutableSet.Builder<Class<?>> serviceClasses = ImmutableSet.builder();
        private boolean isServletRestricted = true;
        private boolean isClientIdWhitelistEnabled = true;

        public Builder addServiceClass(Class<?> serviceClass) {
            this.serviceClasses.add(serviceClass);
            return this;
        }

        public Builder addServiceClasses(Iterable<? extends Class<?>> serviceClasses) {
            this.serviceClasses.addAll(serviceClasses);
            return this;
        }

        public Builder setRestricted(boolean isServletRestricted) {
            this.isServletRestricted = isServletRestricted;
            return this;
        }

        public Builder setClientIdWhitelistEnabled(boolean isClientIdWhitelistEnabled) {
            this.isClientIdWhitelistEnabled = isClientIdWhitelistEnabled;
            return this;
        }

        public ServletInitializationParameters build() {
            return new ServletInitializationParameters(this.serviceClasses.build(), this.isServletRestricted, this.isClientIdWhitelistEnabled);
        }
    }
}

