/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.joda.time.base;

import com.google.appengine.repackaged.org.joda.time.Chronology;
import com.google.appengine.repackaged.org.joda.time.DateTimeUtils;
import com.google.appengine.repackaged.org.joda.time.Duration;
import com.google.appengine.repackaged.org.joda.time.DurationFieldType;
import com.google.appengine.repackaged.org.joda.time.MutablePeriod;
import com.google.appengine.repackaged.org.joda.time.PeriodType;
import com.google.appengine.repackaged.org.joda.time.ReadWritablePeriod;
import com.google.appengine.repackaged.org.joda.time.ReadableDuration;
import com.google.appengine.repackaged.org.joda.time.ReadableInstant;
import com.google.appengine.repackaged.org.joda.time.ReadablePartial;
import com.google.appengine.repackaged.org.joda.time.ReadablePeriod;
import com.google.appengine.repackaged.org.joda.time.base.AbstractPeriod;
import com.google.appengine.repackaged.org.joda.time.base.BaseLocal;
import com.google.appengine.repackaged.org.joda.time.chrono.ISOChronology;
import com.google.appengine.repackaged.org.joda.time.convert.ConverterManager;
import com.google.appengine.repackaged.org.joda.time.convert.PeriodConverter;
import com.google.appengine.repackaged.org.joda.time.field.FieldUtils;
import java.io.Serializable;

public abstract class BasePeriod
extends AbstractPeriod
implements ReadablePeriod,
Serializable {
    private static final long serialVersionUID = -2110953284060001145L;
    private static final ReadablePeriod DUMMY_PERIOD = new AbstractPeriod(){

        @Override
        public int getValue(int index) {
            return 0;
        }

        @Override
        public PeriodType getPeriodType() {
            return PeriodType.time();
        }
    };
    private final PeriodType iType;
    private final int[] iValues;

    protected BasePeriod(int years, int months, int weeks, int days, int hours, int minutes, int seconds, int millis, PeriodType type) {
        this.iType = type = this.checkPeriodType(type);
        this.iValues = this.setPeriodInternal(years, months, weeks, days, hours, minutes, seconds, millis);
    }

    protected BasePeriod(long startInstant, long endInstant, PeriodType type, Chronology chrono) {
        type = this.checkPeriodType(type);
        chrono = DateTimeUtils.getChronology(chrono);
        this.iType = type;
        this.iValues = chrono.get(this, startInstant, endInstant);
    }

    protected BasePeriod(ReadableInstant startInstant, ReadableInstant endInstant, PeriodType type) {
        type = this.checkPeriodType(type);
        if (startInstant == null && endInstant == null) {
            this.iType = type;
            this.iValues = new int[this.size()];
        } else {
            long startMillis = DateTimeUtils.getInstantMillis(startInstant);
            long endMillis = DateTimeUtils.getInstantMillis(endInstant);
            Chronology chrono = DateTimeUtils.getIntervalChronology(startInstant, endInstant);
            this.iType = type;
            this.iValues = chrono.get(this, startMillis, endMillis);
        }
    }

    protected BasePeriod(ReadablePartial start, ReadablePartial end, PeriodType type) {
        if (start == null || end == null) {
            throw new IllegalArgumentException("ReadablePartial objects must not be null");
        }
        if (start instanceof BaseLocal && end instanceof BaseLocal && start.getClass() == end.getClass()) {
            type = this.checkPeriodType(type);
            long startMillis = ((BaseLocal)start).getLocalMillis();
            long endMillis = ((BaseLocal)end).getLocalMillis();
            Chronology chrono = start.getChronology();
            chrono = DateTimeUtils.getChronology(chrono);
            this.iType = type;
            this.iValues = chrono.get(this, startMillis, endMillis);
        } else {
            if (start.size() != end.size()) {
                throw new IllegalArgumentException("ReadablePartial objects must have the same set of fields");
            }
            int isize = start.size();
            for (int i = 0; i < isize; ++i) {
                if (start.getFieldType(i) == end.getFieldType(i)) continue;
                throw new IllegalArgumentException("ReadablePartial objects must have the same set of fields");
            }
            if (!DateTimeUtils.isContiguous(start)) {
                throw new IllegalArgumentException("ReadablePartial objects must be contiguous");
            }
            this.iType = this.checkPeriodType(type);
            Chronology chrono = DateTimeUtils.getChronology(start.getChronology()).withUTC();
            this.iValues = chrono.get(this, chrono.set(start, 0L), chrono.set(end, 0L));
        }
    }

    protected BasePeriod(ReadableInstant startInstant, ReadableDuration duration, PeriodType type) {
        type = this.checkPeriodType(type);
        long startMillis = DateTimeUtils.getInstantMillis(startInstant);
        long durationMillis = DateTimeUtils.getDurationMillis(duration);
        long endMillis = FieldUtils.safeAdd(startMillis, durationMillis);
        Chronology chrono = DateTimeUtils.getInstantChronology(startInstant);
        this.iType = type;
        this.iValues = chrono.get(this, startMillis, endMillis);
    }

    protected BasePeriod(ReadableDuration duration, ReadableInstant endInstant, PeriodType type) {
        type = this.checkPeriodType(type);
        long durationMillis = DateTimeUtils.getDurationMillis(duration);
        long endMillis = DateTimeUtils.getInstantMillis(endInstant);
        long startMillis = FieldUtils.safeSubtract(endMillis, durationMillis);
        Chronology chrono = DateTimeUtils.getInstantChronology(endInstant);
        this.iType = type;
        this.iValues = chrono.get(this, startMillis, endMillis);
    }

    protected BasePeriod(long duration) {
        this.iType = PeriodType.standard();
        int[] values = ISOChronology.getInstanceUTC().get(DUMMY_PERIOD, duration);
        this.iValues = new int[8];
        System.arraycopy(values, 0, this.iValues, 4, 4);
    }

    protected BasePeriod(long duration, PeriodType type, Chronology chrono) {
        type = this.checkPeriodType(type);
        chrono = DateTimeUtils.getChronology(chrono);
        this.iType = type;
        this.iValues = chrono.get(this, duration);
    }

    protected BasePeriod(Object period, PeriodType type, Chronology chrono) {
        PeriodConverter converter = ConverterManager.getInstance().getPeriodConverter(period);
        type = type == null ? converter.getPeriodType(period) : type;
        this.iType = type = this.checkPeriodType(type);
        if (this instanceof ReadWritablePeriod) {
            this.iValues = new int[this.size()];
            chrono = DateTimeUtils.getChronology(chrono);
            converter.setInto((ReadWritablePeriod)((Object)this), period, chrono);
        } else {
            this.iValues = new MutablePeriod(period, type, chrono).getValues();
        }
    }

    protected BasePeriod(int[] values, PeriodType type) {
        this.iType = type;
        this.iValues = values;
    }

    protected PeriodType checkPeriodType(PeriodType type) {
        return DateTimeUtils.getPeriodType(type);
    }

    @Override
    public PeriodType getPeriodType() {
        return this.iType;
    }

    @Override
    public int getValue(int index) {
        return this.iValues[index];
    }

    public Duration toDurationFrom(ReadableInstant startInstant) {
        long startMillis = DateTimeUtils.getInstantMillis(startInstant);
        Chronology chrono = DateTimeUtils.getInstantChronology(startInstant);
        long endMillis = chrono.add(this, startMillis, 1);
        return new Duration(startMillis, endMillis);
    }

    public Duration toDurationTo(ReadableInstant endInstant) {
        long endMillis = DateTimeUtils.getInstantMillis(endInstant);
        Chronology chrono = DateTimeUtils.getInstantChronology(endInstant);
        long startMillis = chrono.add(this, endMillis, -1);
        return new Duration(startMillis, endMillis);
    }

    private void checkAndUpdate(DurationFieldType type, int[] values, int newValue) {
        int index = this.indexOf(type);
        if (index == -1) {
            if (newValue != 0) {
                throw new IllegalArgumentException("Period does not support field '" + type.getName() + "'");
            }
        } else {
            values[index] = newValue;
        }
    }

    protected void setPeriod(ReadablePeriod period) {
        if (period == null) {
            this.setValues(new int[this.size()]);
        } else {
            this.setPeriodInternal(period);
        }
    }

    private void setPeriodInternal(ReadablePeriod period) {
        int[] newValues = new int[this.size()];
        int isize = period.size();
        for (int i = 0; i < isize; ++i) {
            DurationFieldType type = period.getFieldType(i);
            int value = period.getValue(i);
            this.checkAndUpdate(type, newValues, value);
        }
        this.setValues(newValues);
    }

    protected void setPeriod(int years, int months, int weeks, int days, int hours, int minutes, int seconds, int millis) {
        int[] newValues = this.setPeriodInternal(years, months, weeks, days, hours, minutes, seconds, millis);
        this.setValues(newValues);
    }

    private int[] setPeriodInternal(int years, int months, int weeks, int days, int hours, int minutes, int seconds, int millis) {
        int[] newValues = new int[this.size()];
        this.checkAndUpdate(DurationFieldType.years(), newValues, years);
        this.checkAndUpdate(DurationFieldType.months(), newValues, months);
        this.checkAndUpdate(DurationFieldType.weeks(), newValues, weeks);
        this.checkAndUpdate(DurationFieldType.days(), newValues, days);
        this.checkAndUpdate(DurationFieldType.hours(), newValues, hours);
        this.checkAndUpdate(DurationFieldType.minutes(), newValues, minutes);
        this.checkAndUpdate(DurationFieldType.seconds(), newValues, seconds);
        this.checkAndUpdate(DurationFieldType.millis(), newValues, millis);
        return newValues;
    }

    protected void setField(DurationFieldType field, int value) {
        this.setFieldInto(this.iValues, field, value);
    }

    protected void setFieldInto(int[] values, DurationFieldType field, int value) {
        int index = this.indexOf(field);
        if (index == -1) {
            if (value != 0 || field == null) {
                throw new IllegalArgumentException("Period does not support field '" + field + "'");
            }
        } else {
            values[index] = value;
        }
    }

    protected void addField(DurationFieldType field, int value) {
        this.addFieldInto(this.iValues, field, value);
    }

    protected void addFieldInto(int[] values, DurationFieldType field, int value) {
        int index = this.indexOf(field);
        if (index == -1) {
            if (value != 0 || field == null) {
                throw new IllegalArgumentException("Period does not support field '" + field + "'");
            }
        } else {
            values[index] = FieldUtils.safeAdd(values[index], value);
        }
    }

    protected void mergePeriod(ReadablePeriod period) {
        if (period != null) {
            this.setValues(this.mergePeriodInto(this.getValues(), period));
        }
    }

    protected int[] mergePeriodInto(int[] values, ReadablePeriod period) {
        int isize = period.size();
        for (int i = 0; i < isize; ++i) {
            DurationFieldType type = period.getFieldType(i);
            int value = period.getValue(i);
            this.checkAndUpdate(type, values, value);
        }
        return values;
    }

    protected void addPeriod(ReadablePeriod period) {
        if (period != null) {
            this.setValues(this.addPeriodInto(this.getValues(), period));
        }
    }

    protected int[] addPeriodInto(int[] values, ReadablePeriod period) {
        int isize = period.size();
        for (int i = 0; i < isize; ++i) {
            DurationFieldType type = period.getFieldType(i);
            int value = period.getValue(i);
            if (value == 0) continue;
            int index = this.indexOf(type);
            if (index == -1) {
                throw new IllegalArgumentException("Period does not support field '" + type.getName() + "'");
            }
            values[index] = FieldUtils.safeAdd(this.getValue(index), value);
        }
        return values;
    }

    protected void setValue(int index, int value) {
        this.iValues[index] = value;
    }

    protected void setValues(int[] values) {
        System.arraycopy(values, 0, this.iValues, 0, this.iValues.length);
    }
}

