/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flags;

import com.google.appengine.repackaged.com.google.common.flags.DocLevel;
import com.google.appengine.repackaged.com.google.common.flags.FlagDescription;
import com.google.appengine.repackaged.com.google.common.flags.FlagSpec;
import com.google.appengine.repackaged.com.google.common.flags.MalformedFlagDescriptionException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

class XmlSupport {
    private static XMLReader xmlParser;
    static final Pattern TYPENAME_RE;

    private XmlSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fromXml(InputStream xmlStream, Map<String, FlagDescription> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        FlagDescriptionHandler flagHandler = new FlagDescriptionHandler(map);
        Class<XmlSupport> clazz = XmlSupport.class;
        synchronized (XmlSupport.class) {
            if (xmlParser == null) {
                try {
                    xmlParser = XMLReaderFactory.createXMLReader();
                }
                catch (SAXException e) {
                    throw new AssertionError((Object)e);
                }
            }
            xmlParser.setContentHandler(flagHandler);
            xmlParser.setErrorHandler(flagHandler);
            try {
                xmlParser.parse(new InputSource(xmlStream));
            }
            catch (SAXException e) {
                throw new MalformedFlagDescriptionException(e);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            finally {
                xmlParser.setContentHandler(null);
                xmlParser.setErrorHandler(null);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    static Set<FlagDescription> discoverFlags(String className) {
        Class<?> cl;
        HashSet<FlagDescription> flags = new HashSet<FlagDescription>();
        try {
            cl = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return flags;
        }
        for (Field f : cl.getDeclaredFields()) {
            if (!f.isAnnotationPresent(FlagSpec.class)) continue;
            FlagSpec spec = f.getAnnotation(FlagSpec.class);
            String type = f.getGenericType().toString();
            Matcher matcher = TYPENAME_RE.matcher(type);
            if (matcher.matches()) {
                type = matcher.group(1);
            }
            String flagName = f.getDeclaringClass().getName() + "." + f.getName();
            flags.add(FlagDescription.createFlagFromField(flagName).shortFlagName(spec.name()).doc(spec.help()).altName(spec.altName()).docLevel(spec.docLevel()).type(type).build());
        }
        return flags;
    }

    static String serializeOneFlag(FlagDescription desc) {
        if (desc == null) {
            throw new NullPointerException();
        }
        StringBuilder b = new StringBuilder();
        b.append("<flag>");
        b.append(XmlSupport.toXmlElement("name", desc.getFullyQualifiedFieldName()));
        if (desc.isShortFlagNameSpecified()) {
            b.append(XmlSupport.toXmlElement("shortname", desc.getShortFlagName()));
        }
        b.append(XmlSupport.toXmlElement("doc", desc.getDoc()));
        b.append(XmlSupport.toXmlElement("doclevel", desc.getDocLevel().toString()));
        if (desc.getAltName() != null) {
            b.append(XmlSupport.toXmlElement("altname", desc.getAltName()));
        }
        b.append(XmlSupport.toXmlElement("type", desc.getType()));
        b.append("</flag>\n");
        return b.toString();
    }

    static String toXml(Collection<FlagDescription> flags) {
        StringBuilder b = new StringBuilder();
        b.append("<flags>");
        for (FlagDescription d : flags) {
            b.append(XmlSupport.serializeOneFlag(d));
        }
        b.append("</flags>");
        return b.toString();
    }

    static String toXmlElement(String name, String content) {
        return "<" + name + ">" + XmlSupport.xmlEscape(content) + "</" + name + ">";
    }

    static String xmlEscape(String s) {
        s = s.replaceAll("&", "&amp;");
        s = s.replaceAll("<", "&lt;");
        s = s.replaceAll(">", "&gt;");
        s = s.replaceAll("\"", "&quot;");
        return s;
    }

    private static String xmlUnescape(String s) {
        s = s.replaceAll("&quot;", "\"");
        s = s.replaceAll("&gt;", ">");
        s = s.replaceAll("&lt;", "<");
        s = s.replaceAll("&amp;", "&");
        return s;
    }

    static {
        TYPENAME_RE = Pattern.compile("com.google.common.flags.Flag<(.*)>");
    }

    private static class FlagDescriptionHandler
    extends DefaultHandler {
        private Map<String, FlagDescription> flagDescriptions;
        private List<String> flagContainers = new ArrayList<String>();
        private ParseState parseState = ParseState.FLAGS;
        private StringBuilder nodeData = new StringBuilder();
        private final String[] flagNodeChildren = new String[]{"name", "shortname", "doc", "doclevel", "altname", "type"};
        private Map<String, String> flagFields = new HashMap<String, String>();

        public FlagDescriptionHandler(Map<String, FlagDescription> map) {
            this.flagDescriptions = map;
            this.clearFlagFields();
        }

        private void clearFlagFields() {
            for (String elementName : this.flagNodeChildren) {
                this.flagFields.put(elementName, null);
            }
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) {
            switch (this.parseState) {
                case FLAGS: {
                    if ("flag".equals(qName)) {
                        this.parseState = ParseState.FLAG;
                        break;
                    }
                    if (!"flagcontainer".equals(qName)) break;
                    this.parseState = ParseState.FLAG_CONTAINER;
                    break;
                }
                case FLAG: {
                    if (this.flagFields.get(qName) != null) {
                        throw new MalformedFlagDescriptionException("Duplicate element encountered while parsing flag " + this.currentFlagName() + ": " + qName);
                    }
                    this.parseState = ParseState.FLAG_CHILD;
                    break;
                }
                default: {
                    throw new MalformedFlagDescriptionException("Unexpected parse state");
                }
            }
        }

        private String currentFlagName() {
            String flagName = this.flagFields.get("name");
            return flagName == null ? "<unknown>" : flagName;
        }

        @Override
        public void characters(char[] chunk, int offset, int length) {
            if (this.parseState == ParseState.FLAGS) {
                return;
            }
            this.nodeData.append(chunk, offset, length);
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            switch (this.parseState) {
                case FLAGS: {
                    return;
                }
                case FLAG: {
                    FlagDescription d = this.makeFlagDescription();
                    if (!this.flagDescriptions.containsKey(d.getLongFlagName())) {
                        this.flagDescriptions.put(d.getLongFlagName(), d);
                    }
                    this.clearFlagFields();
                    this.parseState = ParseState.FLAGS;
                    break;
                }
                case FLAG_CHILD: {
                    if (!this.flagFields.containsKey(qName)) {
                        throw new MalformedFlagDescriptionException("Unknown element encountered while parsing flag named " + this.currentFlagName() + ": " + qName);
                    }
                    this.flagFields.put(qName, XmlSupport.xmlUnescape(this.nodeData.toString().trim()));
                    this.parseState = ParseState.FLAG;
                    break;
                }
                case FLAG_CONTAINER: {
                    this.flagContainers.add(XmlSupport.xmlUnescape(this.nodeData.toString().trim()));
                    this.parseState = ParseState.FLAGS;
                    break;
                }
                default: {
                    throw new MalformedFlagDescriptionException("Unhandled element: " + qName);
                }
            }
            this.nodeData.setLength(0);
        }

        private FlagDescription makeFlagDescription() {
            DocLevel docLevel;
            String fullyQualifiedFieldName = this.flagFields.get("name");
            if (fullyQualifiedFieldName == null) {
                throw new MalformedFlagDescriptionException("name missing");
            }
            String level = this.flagFields.get("doclevel");
            if (level == null) {
                throw new MalformedFlagDescriptionException("doclevel missing for flag " + fullyQualifiedFieldName);
            }
            try {
                docLevel = Enum.valueOf(DocLevel.class, level);
            }
            catch (IllegalArgumentException e) {
                throw new MalformedFlagDescriptionException("Illegal doclevel for flag " + fullyQualifiedFieldName + ": " + level);
            }
            String doc = this.flagFields.get("doc");
            if (doc == null) {
                throw new MalformedFlagDescriptionException("doc missing for flag " + fullyQualifiedFieldName);
            }
            String type = this.flagFields.get("type");
            if (type == null) {
                throw new MalformedFlagDescriptionException("type missing for flag " + fullyQualifiedFieldName);
            }
            return FlagDescription.createFlagFromField(fullyQualifiedFieldName).shortFlagName(this.flagFields.get("shortname")).doc(doc).altName(this.flagFields.get("altname")).docLevel(docLevel).type(type).build();
        }

        @Override
        public void endDocument() {
            for (String className : this.flagContainers) {
                Set<FlagDescription> flags = XmlSupport.discoverFlags(className);
                for (FlagDescription d : flags) {
                    if (this.flagDescriptions.containsKey(d.getLongFlagName())) continue;
                    this.flagDescriptions.put(d.getLongFlagName(), d);
                }
            }
        }
    }

    private static class FlagElementName {
        private static final String NAME = "name";
        private static final String SHORTNAME = "shortname";
        private static final String ALTNAME = "altname";
        private static final String TYPE = "type";
        private static final String DOC = "doc";
        private static final String DOCLEVEL = "doclevel";

        private FlagElementName() {
        }
    }

    private static enum ParseState {
        FLAGS,
        FLAG,
        FLAG_CHILD,
        FLAG_CONTAINER;

    }
}

