/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.files;

import com.google.appengine.api.files.Crc32c;
import com.google.appengine.api.files.FileWriteChannel;
import com.google.appengine.api.files.RecordConstants;
import com.google.appengine.api.files.RecordWriteChannel;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

final class RecordWriteChannelImpl
implements RecordWriteChannel {
    private final Object lock = new Object();
    private final FileWriteChannel output;
    private int position;
    private ByteBuffer writeBuffer;

    public RecordWriteChannelImpl(FileWriteChannel output) {
        this.output = output;
        this.position = 0;
        this.writeBuffer = ByteBuffer.allocate(32768);
        this.writeBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer data) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            return this.write(data, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpen() {
        Object object = this.lock;
        synchronized (object) {
            return this.output.isOpen();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer data, String sequenceKey) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.writeBuffer.clear();
            this.extendBufferIfNecessary(data);
            int oldPosition = this.position;
            Record lastRecord = new Record();
            do {
                Record currentRecord;
                if ((currentRecord = this.createRecord(data, lastRecord)).getType() == RecordConstants.RecordType.NONE) {
                    this.writeBlanks(currentRecord.getBytes());
                } else {
                    this.writePhysicalRecord(data, currentRecord);
                }
                this.position = oldPosition + this.writeBuffer.position();
                lastRecord = currentRecord;
            } while (data.hasRemaining());
            this.writeBuffer.flip();
            if (sequenceKey == null) {
                return this.output.write(this.writeBuffer);
            }
            return this.output.write(this.writeBuffer, sequenceKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeFinally() throws IllegalStateException, IOException {
        Object object = this.lock;
        synchronized (object) {
            this.closeStream();
            this.output.closeFinally();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.closeStream();
            this.output.close();
        }
    }

    private Record createRecord(ByteBuffer data, Record lastRecord) {
        int bytesToBlockEnd = 32768 - this.position % 32768;
        int minBytesToWrite = data.limit() + 7 - data.position();
        RecordConstants.RecordType type = RecordConstants.RecordType.UNKNOWN;
        int bytes = -1;
        if (bytesToBlockEnd < 7) {
            type = lastRecord.getType();
            bytes = bytesToBlockEnd;
        } else if (lastRecord.getType() == RecordConstants.RecordType.NONE && minBytesToWrite <= bytesToBlockEnd) {
            type = RecordConstants.RecordType.FULL;
            bytes = minBytesToWrite - 7;
        } else if (lastRecord.getType() == RecordConstants.RecordType.NONE) {
            type = RecordConstants.RecordType.FIRST;
            bytes = bytesToBlockEnd - 7;
        } else if (minBytesToWrite <= bytesToBlockEnd) {
            type = RecordConstants.RecordType.LAST;
            bytes = data.limit() - data.position();
        } else {
            type = RecordConstants.RecordType.MIDDLE;
            bytes = bytesToBlockEnd - 7;
        }
        return new Record(type, bytes);
    }

    private void writePhysicalRecord(ByteBuffer data, Record record) {
        this.writeBuffer.putInt(this.generateCrc(data.array(), data.position(), record.getBytes(), record.getType()));
        this.writeBuffer.putShort((short)record.getBytes());
        this.writeBuffer.put(record.getType().value());
        this.writeBuffer.put(data.array(), data.position(), record.getBytes());
        data.position(data.position() + record.getBytes());
    }

    private void writeBlanks(int numBlanks) {
        for (int i = 0; i < numBlanks; ++i) {
            this.writeBuffer.put((byte)0);
        }
    }

    private int generateCrc(byte[] data, int off, int len, RecordConstants.RecordType type) {
        Crc32c crc = new Crc32c();
        crc.update(type.value());
        crc.update(data, off, len);
        return (int)RecordConstants.maskCrc(crc.getValue());
    }

    private void extendBufferIfNecessary(ByteBuffer record) {
        int capacity;
        int maxNumHeaders = 1 + (int)Math.ceil(record.limit() / 32761);
        int maxRecordSize = record.limit() + maxNumHeaders * 7;
        for (capacity = this.writeBuffer.capacity(); capacity < maxRecordSize; capacity *= 2) {
        }
        this.writeBuffer = ByteBuffer.allocate(capacity);
        this.writeBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    private void closeStream() throws IOException {
        this.writeBuffer.clear();
        int bytesToBlockEnd = 32768 - this.position % 32768;
        if (bytesToBlockEnd == 32768) {
            return;
        }
        this.writeBlanks(bytesToBlockEnd);
        this.writeBuffer.flip();
        this.position += this.writeBuffer.limit();
        this.output.write(this.writeBuffer);
    }

    private static final class Record {
        private final RecordConstants.RecordType type;
        private final int bytes;

        private Record() {
            this.type = RecordConstants.RecordType.NONE;
            this.bytes = 0;
        }

        private Record(RecordConstants.RecordType type, int bytes) {
            Preconditions.checkArgument(type != RecordConstants.RecordType.UNKNOWN);
            Preconditions.checkArgument(bytes >= 0);
            this.type = type;
            this.bytes = bytes;
        }

        int getBytes() {
            return this.bytes;
        }

        RecordConstants.RecordType getType() {
            return this.type;
        }
    }
}

