/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.base;

import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.common.logging.escalate.EscalatingLogger;
import com.google.appengine.repackaged.com.google.common.logging.escalate.ThrottlingEscalator;
import com.google.appengine.repackaged.com.google.io.base.ServerAddress;
import com.google.appengine.repackaged.com.google.io.base.SocketConnector;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class TimedConnect {
    private static ExecutorService tpool = Executors.newCachedThreadPool();
    private static final int bins = 64;
    private static final List<Set<ServerAddress>> hung = Lists.newArrayListWithCapacity(64);
    private static final long THROTTLING_TIME_FRAME = 600000L;
    private static final int THROTTLING_THRESHOLD = 10;
    private static final EscalatingLogger escalatingLogger;

    public static Socket connect(ServerAddress address, int timeout) throws IOException, InterruptedIOException {
        return TimedConnect.connect(address, SocketConnector.DEFAULT, timeout);
    }

    public static Socket connect(ServerAddress address, SocketConnector socketConnector, int timeout) throws IOException {
        return TimedConnect.connectHelper(address, socketConnector, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Socket connectHelper(final ServerAddress address, final SocketConnector socketConnector, int timeout) throws IOException, InterruptedIOException {
        Set<ServerAddress> hungBucket;
        if (socketConnector == SocketConnector.DEFAULT) {
            Socket s = new Socket();
            try {
                s.connect(new InetSocketAddress(address.host, address.port), timeout);
                return s;
            }
            catch (SocketTimeoutException e) {
                return null;
            }
        }
        long done_time = System.currentTimeMillis() + (long)timeout;
        Set<ServerAddress> set = hungBucket = hung.get(Math.abs(address.hashCode() % 64));
        synchronized (set) {
            while (hungBucket.contains(address)) {
                long left = done_time - System.currentTimeMillis();
                if (left < 0L) {
                    return null;
                }
                try {
                    hungBucket.wait(left);
                }
                catch (InterruptedException ie) {
                    InterruptedIOException exception = new InterruptedIOException();
                    exception.initCause(ie);
                    throw exception;
                }
            }
            hungBucket.add(address);
        }
        Future<Socket> future = tpool.submit(new Callable<Socket>(){

            @Override
            public Socket call() throws IOException {
                return socketConnector.connect(address);
            }

            public String toString() {
                return "Worker thread connecting to " + address;
            }
        });
        try {
            Socket socket = future.get(done_time - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            return socket;
        }
        catch (ExecutionException e) {
            IOException exception = new IOException(e.getCause());
            escalatingLogger.log(Level.WARNING, "Could not open a connection to " + address, (Throwable)exception);
            Socket socket = null;
            return socket;
        }
        catch (TimeoutException e) {
            Socket exception = null;
            return exception;
        }
        catch (InterruptedException ie) {
            InterruptedIOException exception = new InterruptedIOException();
            exception.initCause(ie);
            throw exception;
        }
        finally {
            Set<ServerAddress> set2 = hungBucket;
            synchronized (set2) {
                hungBucket.remove(address);
                hungBucket.notifyAll();
            }
        }
    }

    static {
        for (int i = 0; i < 64; ++i) {
            hung.add(Sets.newHashSet());
        }
        escalatingLogger = new EscalatingLogger(Logger.getLogger(TimedConnect.class.getName()), (EscalatingLogger.Escalator)new ThrottlingEscalator(600000L, 10, Level.INFO));
    }
}

