/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.Field;
import com.google.appengine.api.search.checkers.FieldChecker;
import com.google.appengine.repackaged.com.google.appengine.api.search.SearchServicePb;
import com.google.apphosting.api.search.DocumentPb;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Schema {
    private final Map<String, List<Field.FieldType>> fieldMap;

    private Schema(Builder builder) {
        this.fieldMap = Collections.unmodifiableMap(builder.fieldMap);
    }

    public Set<String> getFieldNames() {
        return this.fieldMap.keySet();
    }

    public List<Field.FieldType> getFieldTypes(String fieldName) {
        List<Field.FieldType> fieldTypes = this.fieldMap.get(fieldName);
        if (fieldTypes != null) {
            return Collections.unmodifiableList(fieldTypes);
        }
        return Collections.emptyList();
    }

    public String toString() {
        return String.format("Schema{fieldMap: %s}", this.fieldMap);
    }

    static Field.FieldType mapPBFieldTypeToPublic(DocumentPb.FieldValue.ContentType type) {
        switch (type) {
            case TEXT: {
                return Field.FieldType.TEXT;
            }
            case HTML: {
                return Field.FieldType.HTML;
            }
            case ATOM: {
                return Field.FieldType.ATOM;
            }
            case DATE: {
                return Field.FieldType.DATE;
            }
            case NUMBER: {
                return Field.FieldType.NUMBER;
            }
            case GEO: {
                return Field.FieldType.GEO_POINT;
            }
        }
        throw new IllegalArgumentException("Unsupported field type " + type);
    }

    static DocumentPb.FieldValue.ContentType mapPublicFieldTypeToPB(Field.FieldType type) {
        switch (type) {
            case TEXT: {
                return DocumentPb.FieldValue.ContentType.TEXT;
            }
            case HTML: {
                return DocumentPb.FieldValue.ContentType.HTML;
            }
            case ATOM: {
                return DocumentPb.FieldValue.ContentType.ATOM;
            }
            case DATE: {
                return DocumentPb.FieldValue.ContentType.DATE;
            }
            case NUMBER: {
                return DocumentPb.FieldValue.ContentType.NUMBER;
            }
            case GEO_POINT: {
                return DocumentPb.FieldValue.ContentType.GEO;
            }
        }
        throw new IllegalArgumentException("Unsupported field type " + (Object)((Object)type));
    }

    static Schema createSchema(SearchServicePb.IndexMetadata metadata) {
        if (metadata.getFieldCount() == 0) {
            return null;
        }
        HashMap fieldMap = new HashMap();
        Builder builder = Schema.newBuilder();
        for (DocumentPb.FieldTypes fieldTypes : metadata.getFieldList()) {
            String fieldName = fieldTypes.getName();
            for (DocumentPb.FieldValue.ContentType type : fieldTypes.getTypeList()) {
                builder.addTypedField(fieldName, Schema.mapPBFieldTypeToPublic(type));
            }
        }
        return builder.build();
    }

    public int hashCode() {
        return this.fieldMap.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.fieldMap.equals(((Schema)obj).fieldMap);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, List<Field.FieldType>> fieldMap = new HashMap<String, List<Field.FieldType>>();

        protected Builder() {
        }

        public Builder addTypedField(String fieldName, Field.FieldType fieldType) {
            FieldChecker.checkFieldName(fieldName);
            List<Field.FieldType> types = this.fieldMap.get(fieldName);
            if (types == null) {
                types = new ArrayList<Field.FieldType>();
                this.fieldMap.put(fieldName, types);
            }
            types.add(fieldType);
            return this;
        }

        public Schema build() {
            return new Schema(this);
        }
    }
}

