/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.CacheValueUtil;
import com.google.appengine.api.datastore.CurrentTransactionProvider;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityCache;
import com.google.appengine.api.datastore.EntityCachingStrategy;
import com.google.appengine.api.datastore.EntityTranslator;
import com.google.appengine.api.datastore.FutureHelper;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.MemcacheServiceHelper;
import com.google.appengine.api.datastore.ReadPolicy;
import com.google.appengine.api.memcache.MemcacheService;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.apphosting.datastore.EntityStorage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;

final class DatastoreBackedEntityCachingStrategy
extends EntityCachingStrategy {
    private final EntityCache cache;
    private final DatastoreServiceConfig datastoreServiceConfig;

    DatastoreBackedEntityCachingStrategy(DatastoreServiceConfig datastoreServiceConfig) {
        MemcacheServiceHelper memcacheServiceHelper = MemcacheServiceHelper.Builder.withLogAndAbsorbMemcacheServiceErrors();
        double datastoreRpcDeadline = datastoreServiceConfig.getDeadline() == null ? 60.0 : datastoreServiceConfig.getDeadline();
        this.cache = new EntityCache(memcacheServiceHelper, datastoreRpcDeadline);
        this.datastoreServiceConfig = datastoreServiceConfig;
    }

    DatastoreBackedEntityCachingStrategy(EntityCache cache, DatastoreServiceConfig datastoreServiceConfig) {
        this.cache = cache;
        this.datastoreServiceConfig = datastoreServiceConfig;
    }

    @Override
    public EntityCachingStrategy.PreGetCachingResult preGet(CurrentTransactionProvider currentTxnProvider, List<Key> keysToGet, Map<Key, Entity> resultMap) {
        HashSet<Key> keysToSkipLoading = Sets.newHashSet();
        Future<Set<Key>> readInProgressKeys = new FutureHelper.FakeFuture<Set<Key>>(ImmutableSet.of());
        if (currentTxnProvider.getCurrentTransaction(null) != null || this.datastoreServiceConfig.getReadPolicy().getConsistency() == ReadPolicy.Consistency.EVENTUAL) {
            return new DatastoreBackedPreGetCachingResult(keysToSkipLoading, readInProgressKeys);
        }
        List<Key> cacheableKeys = DatastoreBackedEntityCachingStrategy.getCacheableKeys(this.datastoreServiceConfig, keysToGet);
        Map<Key, EntityCache.IdentifiableCacheValue> getResults = FutureHelper.quietGet(this.cache.getIdentifiableAsync(cacheableKeys));
        HashSet<Key> uncachedKeys = Sets.newHashSet(cacheableKeys);
        for (Map.Entry<Key, EntityCache.IdentifiableCacheValue> result : getResults.entrySet()) {
            Key key = result.getKey();
            uncachedKeys.remove(key);
            EntityStorage.CacheValue value = result.getValue().getValue();
            if (value.getStateEnum() != EntityStorage.CacheValue.State.ENTITY) continue;
            keysToSkipLoading.add(key);
            if (!value.hasEntity()) continue;
            resultMap.put(key, EntityTranslator.createFromPb(value.getEntity().getV3Entity()));
        }
        if (!uncachedKeys.isEmpty()) {
            readInProgressKeys = this.cache.putStateAsync(uncachedKeys, EntityStorage.CacheValue.State.READ_IN_PROGRESS, MemcacheService.SetPolicy.ADD_ONLY_IF_NOT_PRESENT);
        }
        return new DatastoreBackedPreGetCachingResult(keysToSkipLoading, readInProgressKeys);
    }

    @Override
    protected void postGet(EntityCachingStrategy.PreGetCachingResult preGetResult, Map<Key, Entity> resultMap) {
        DatastoreBackedPreGetCachingResult preGetStrategyResult = (DatastoreBackedPreGetCachingResult)preGetResult;
        Set<Key> readInProgressKeys = FutureHelper.quietGet(preGetStrategyResult.getReadInProgressKeys());
        if (!readInProgressKeys.isEmpty()) {
            Map<Key, EntityCache.IdentifiableCacheValue> readInProgressCacheValues = FutureHelper.quietGet(this.cache.getIdentifiableAsync(readInProgressKeys));
            HashMap<Key, EntityCache.CasCacheValues> cacheValuesToUpdate = Maps.newHashMapWithExpectedSize(readInProgressCacheValues.size());
            for (Map.Entry<Key, EntityCache.IdentifiableCacheValue> readInProgressMapEntry : readInProgressCacheValues.entrySet()) {
                Key key = readInProgressMapEntry.getKey();
                EntityCache.IdentifiableCacheValue oldIdCacheValue = readInProgressMapEntry.getValue();
                EntityStorage.CacheValue oldCacheValue = oldIdCacheValue.getValue();
                if (oldCacheValue.getStateEnum() != EntityStorage.CacheValue.State.READ_IN_PROGRESS) continue;
                Entity entity = resultMap.get(key);
                EntityStorage.CacheValue newCacheValue = CacheValueUtil.createCacheValue(EntityStorage.CacheValue.State.ENTITY, entity == null ? null : EntityTranslator.convertToPb(entity));
                cacheValuesToUpdate.put(key, new EntityCache.CasCacheValues(oldIdCacheValue, newCacheValue));
            }
            if (!cacheValuesToUpdate.isEmpty()) {
                this.cache.putIfUntouchedAsync(cacheValuesToUpdate);
            }
        }
    }

    @Override
    public EntityCachingStrategy.PreMutationCachingResult prePut(CurrentTransactionProvider currentTxnProvider, List<Entity> entitiesToPut) {
        if (currentTxnProvider.getCurrentTransaction(null) == null) {
            return this.preCommit(entitiesToPut, ImmutableList.<Key>of());
        }
        return new EntityCachingStrategy.PreMutationCachingResult(ImmutableSet.<Key>of());
    }

    @Override
    public EntityCachingStrategy.PreMutationCachingResult preDelete(CurrentTransactionProvider currentTxnProvider, List<Key> keysToDelete) {
        if (currentTxnProvider.getCurrentTransaction(null) == null) {
            return this.preCommit(ImmutableList.<Entity>of(), keysToDelete);
        }
        return new EntityCachingStrategy.PreMutationCachingResult(ImmutableSet.<Key>of());
    }

    @Override
    public EntityCachingStrategy.PreMutationCachingResult preCommit(List<Entity> entitiesToPut, List<Key> keysToDelete) {
        List<Entity> cacheableEntitiesToPut = DatastoreBackedEntityCachingStrategy.getCacheableEntities(this.datastoreServiceConfig, entitiesToPut);
        List<Key> cacheableKeysToDelete = DatastoreBackedEntityCachingStrategy.getCacheableKeys(this.datastoreServiceConfig, keysToDelete);
        HashSet<Key> completeKeys = Sets.newHashSetWithExpectedSize(cacheableEntitiesToPut.size() + cacheableKeysToDelete.size());
        completeKeys.addAll(cacheableKeysToDelete);
        for (Entity entity : cacheableEntitiesToPut) {
            Key key = entity.getKey();
            if (!key.isComplete()) continue;
            completeKeys.add(key);
        }
        Map<Key, EntityCache.IdentifiableCacheValue> mutationInProgressCacheValues = completeKeys.isEmpty() ? ImmutableMap.of() : this.cache.putStateIdentifiable(completeKeys, EntityStorage.CacheValue.State.MUTATION_IN_PROGRESS, MemcacheService.SetPolicy.SET_ALWAYS);
        return new DatastoreBackedPreMutationCachingResult(completeKeys, mutationInProgressCacheValues);
    }

    @Override
    protected void postMutation(EntityCachingStrategy.PreMutationCachingResult preMutationResult) {
        DatastoreBackedPreMutationCachingResult preMutationStrategyResult = (DatastoreBackedPreMutationCachingResult)preMutationResult;
        if (preMutationStrategyResult.getMutationKeys().isEmpty()) {
            return;
        }
        Set<Object> updatedKeys = ImmutableSet.of();
        if (!preMutationStrategyResult.getMutationInProgressCacheValues().isEmpty()) {
            updatedKeys = FutureHelper.quietGet(this.cache.evictIfUntouchedAsync(preMutationStrategyResult.getMutationInProgressCacheValues()));
        }
        Set<Key> nonUpdatedKeys = preMutationStrategyResult.getMutationKeys();
        nonUpdatedKeys.removeAll(updatedKeys);
        if (!nonUpdatedKeys.isEmpty()) {
            Map<Key, EntityCache.IdentifiableCacheValue> cacheEntriesNotUpdated = FutureHelper.quietGet(this.cache.getIdentifiableAsync(nonUpdatedKeys));
            Iterator<Map.Entry<Key, EntityCache.IdentifiableCacheValue>> cacheEntriesNotUpdatedIter = cacheEntriesNotUpdated.entrySet().iterator();
            while (cacheEntriesNotUpdatedIter.hasNext()) {
                Map.Entry<Key, EntityCache.IdentifiableCacheValue> cacheEntry = cacheEntriesNotUpdatedIter.next();
                EntityStorage.CacheValue value = cacheEntry.getValue().getValue();
                if (value.getStateEnum() == EntityStorage.CacheValue.State.ENTITY || value.getStateEnum() == EntityStorage.CacheValue.State.READ_IN_PROGRESS) continue;
                cacheEntriesNotUpdatedIter.remove();
            }
            FutureHelper.quietGet(this.cache.evictIfUntouchedAsync(cacheEntriesNotUpdated));
        }
    }

    static final class DatastoreBackedPreMutationCachingResult
    extends EntityCachingStrategy.PreMutationCachingResult {
        private final Set<Key> mutationKeys;
        private final Map<Key, EntityCache.IdentifiableCacheValue> mutationInProgressCacheValues;

        public DatastoreBackedPreMutationCachingResult(Set<Key> mutationKeys, Map<Key, EntityCache.IdentifiableCacheValue> mutationInProgressCacheValues) {
            super(ImmutableSet.<Key>of());
            this.mutationKeys = mutationKeys;
            this.mutationInProgressCacheValues = mutationInProgressCacheValues;
        }

        public Set<Key> getMutationKeys() {
            return this.mutationKeys;
        }

        public Map<Key, EntityCache.IdentifiableCacheValue> getMutationInProgressCacheValues() {
            return this.mutationInProgressCacheValues;
        }
    }

    static final class DatastoreBackedPreGetCachingResult
    extends EntityCachingStrategy.PreGetCachingResult {
        private final Future<Set<Key>> readInProgressKeys;

        public DatastoreBackedPreGetCachingResult(Set<Key> keysToSkipLoading, Future<Set<Key>> readInProgressKeys) {
            super(keysToSkipLoading);
            this.readInProgressKeys = readInProgressKeys;
        }

        public Future<Set<Key>> getReadInProgressKeys() {
            return this.readInProgressKeys;
        }
    }
}

