/* -*- C++ -*-

  MacOS X implementation of the SKK input method.

  Copyright (C) 2008 Tomotaka SUWA <t.suwa@mac.com>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef SKKInputEngineOption_h
#define SKKInputEngineOption_h

class SKKInputEngineOption {
public:
    virtual ~SKKInputEngineOption() {}

    // 中間的な変換を訂正するか(n → ん)
    virtual bool FixIntermediateConversion() = 0;

    // 自動ダイナミック補完を有効にするか
    virtual bool EnableDynamicCompletion() = 0;

    // 自動ダイナミック補完の幅(表示数)
    virtual int DynamicCompletionRange() = 0;

    // アノテーションを有効にするか
    virtual bool EnableAnnotation() = 0;
};

#endif
