/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.atto;

import java.math.BigInteger;
import java.util.List;
import net.morilib.lisp.atto.Appliable;
import net.morilib.lisp.atto.Callback;
import net.morilib.lisp.atto.Cell;
import net.morilib.lisp.atto.Closure;
import net.morilib.lisp.atto.Environment;
import net.morilib.lisp.atto.LispAtto;
import net.morilib.lisp.atto.Symbol;

public class SimpleEngine
implements Callback {
    private static final BigInteger MAXINT_1 = BigInteger.valueOf(0x80000000L);
    private static final BigInteger MININT_1 = BigInteger.valueOf(-2147483649L);
    static final SimpleEngine INSTANCE = new SimpleEngine();
    static final Appliable CONS = new Appliable(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length == 2) {
                return new Cell(args[0], args[1]);
            }
            throw new IllegalArgumentException();
        }
    };
    static final Appliable EQ = new Appliable(){

        @Override
        public Object apply(Callback b, Object ... args) {
            Object p = null;
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (p != null && p != o) {
                    return Boolean.FALSE;
                }
                p = o;
                ++n2;
            }
            return Boolean.TRUE;
        }
    };
    static final Appliable EQV = new Appliable(){

        @Override
        public Object apply(Callback b, Object ... args) {
            Object p = null;
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (p != null && !p.equals(o)) {
                    return Boolean.FALSE;
                }
                p = o;
                ++n2;
            }
            return Boolean.TRUE;
        }
    };
    static final Appliable CAR = new Appliable(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length != 1) {
                throw new IllegalArgumentException();
            }
            if (args[0] instanceof Cell) {
                return ((Cell)args[0]).car;
            }
            throw new IllegalArgumentException();
        }
    };
    static final Appliable CDR = new Appliable(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length != 1) {
                throw new IllegalArgumentException();
            }
            if (args[0] instanceof Cell) {
                return ((Cell)args[0]).cdr;
            }
            throw new IllegalArgumentException();
        }
    };
    static final Appliable ATOM = new Appliable(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length == 1) {
                return new Boolean(!(args[0] instanceof Cell));
            }
            throw new IllegalArgumentException();
        }
    };
    static final Appliable NULL = new Appliable(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length == 1) {
                return new Boolean(args[0] == Cell.NIL);
            }
            throw new IllegalArgumentException();
        }
    };
    static final Appliable SYMBOL = new Appliable(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length == 1) {
                return new Boolean(args[0] instanceof Symbol);
            }
            throw new IllegalArgumentException();
        }
    };
    static final Appliable ERROR = new Appliable(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length == 1) {
                throw new IllegalArgumentException(args[0].toString());
            }
            throw new IllegalArgumentException();
        }
    };
    static final Appliable SET_CAR = new Appliable(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length != 2) {
                throw new IllegalArgumentException();
            }
            if (args[0] instanceof Cell) {
                ((Cell)args[0]).car = args[1];
                return LispAtto.UNDEF;
            }
            throw new IllegalArgumentException();
        }
    };
    static final Appliable SET_CDR = new Appliable(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length != 2) {
                throw new IllegalArgumentException();
            }
            if (args[0] instanceof Cell) {
                ((Cell)args[0]).cdr = args[1];
                return LispAtto.UNDEF;
            }
            throw new IllegalArgumentException();
        }
    };
    static final Appliable APPLY = new Appliable(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length != 2) {
                throw new IllegalArgumentException();
            }
            if (args[0] instanceof Appliable) {
                Object[] a = LispAtto.toArray(args[1]);
                return ((Appliable)args[0]).apply(b, a);
            }
            throw new IllegalArgumentException();
        }
    };
    static final Appliable INC = new Appliable(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length != 1) {
                throw new IllegalArgumentException();
            }
            if (args[0] instanceof Integer) {
                int x = (Integer)args[0];
                return x < Integer.MAX_VALUE ? Integer.valueOf(x + 1) : MAXINT_1;
            }
            if (args[0] instanceof BigInteger) {
                return ((BigInteger)args[0]).add(BigInteger.ONE);
            }
            if (args[0] instanceof Number) {
                return new Double(((Number)args[0]).doubleValue() + 1.0);
            }
            throw new IllegalArgumentException(args[0].toString());
        }
    };
    static final Appliable DEC = new Appliable(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length != 1) {
                throw new IllegalArgumentException();
            }
            if (args[0] instanceof Integer) {
                int x = (Integer)args[0];
                return x > Integer.MIN_VALUE ? Integer.valueOf(x - 1) : MININT_1;
            }
            if (args[0] instanceof BigInteger) {
                return ((BigInteger)args[0]).subtract(BigInteger.ONE);
            }
            if (args[0] instanceof Number) {
                return new Double(((Number)args[0]).doubleValue() - 1.0);
            }
            throw new IllegalArgumentException();
        }
    };
    static final Appliable GT = new Appliable(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object apply(Callback b, Object ... args) {
            Integer pi = null;
            BigInteger pb = null;
            Double pd = null;
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (pi != null) {
                    if (o instanceof Integer) {
                        if (pi.compareTo((Integer)o) <= 0) return Boolean.FALSE;
                        pi = (Integer)o;
                    } else {
                        if (o instanceof BigInteger) {
                            return Boolean.FALSE;
                        }
                        if (!(o instanceof Double)) throw new IllegalArgumentException();
                        if (!(pi.doubleValue() > (Double)o)) return Boolean.FALSE;
                        pd = (Double)o;
                        pi = null;
                    }
                } else if (pb != null) {
                    if (o instanceof Integer) {
                        pi = (Integer)o;
                        pb = null;
                    } else if (o instanceof BigInteger) {
                        if (pb.compareTo((BigInteger)o) <= 0) return Boolean.FALSE;
                        pb = (BigInteger)o;
                    } else {
                        if (!(o instanceof Double)) throw new IllegalArgumentException();
                        if (!(pb.doubleValue() > (Double)o)) return Boolean.FALSE;
                        pd = (Double)o;
                        pb = null;
                    }
                } else if (pd != null) {
                    double d = pd;
                    if (!(o instanceof Number)) {
                        throw new IllegalArgumentException();
                    }
                    if (!(d > ((Number)o).doubleValue())) return Boolean.FALSE;
                    pd = new Double(((Number)o).doubleValue());
                    pb = null;
                    pi = null;
                } else if (o instanceof Integer) {
                    pi = (Integer)o;
                } else if (o instanceof BigInteger) {
                    pb = (BigInteger)o;
                } else {
                    if (!(o instanceof Double)) throw new IllegalArgumentException();
                    pd = (Double)o;
                }
                ++n2;
            }
            return Boolean.TRUE;
        }
    };
    static final Appliable LT = new Appliable(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Object apply(Callback b, Object ... args) {
            Integer pi = null;
            BigInteger pb = null;
            Double pd = null;
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (pi != null) {
                    if (o instanceof Integer) {
                        if (pi.compareTo((Integer)o) >= 0) return Boolean.FALSE;
                        pi = (Integer)o;
                    } else if (o instanceof BigInteger) {
                        pb = BigInteger.valueOf(pi.intValue());
                        if (pb.compareTo((BigInteger)o) >= 0) return Boolean.FALSE;
                        pb = (BigInteger)o;
                        pi = null;
                    } else {
                        if (!(o instanceof Double)) throw new IllegalArgumentException();
                        if (!(pi.doubleValue() < (Double)o)) return Boolean.FALSE;
                        pd = (Double)o;
                        pi = null;
                    }
                } else if (pb != null) {
                    if (o instanceof Integer) {
                        return Boolean.FALSE;
                    }
                    if (o instanceof BigInteger) {
                        if (pb.compareTo((BigInteger)o) >= 0) return Boolean.FALSE;
                        pb = (BigInteger)o;
                    } else {
                        if (!(o instanceof Double)) throw new IllegalArgumentException();
                        if (!(pb.doubleValue() < (Double)o)) return Boolean.FALSE;
                        pd = (Double)o;
                        pb = null;
                    }
                } else if (pd != null) {
                    double d = pd;
                    if (!(o instanceof Number)) {
                        throw new IllegalArgumentException();
                    }
                    if (!(d < ((Number)o).doubleValue())) return Boolean.FALSE;
                    pd = new Double(((Number)o).doubleValue());
                    pb = null;
                    pi = null;
                } else if (o instanceof Integer) {
                    pi = (Integer)o;
                } else if (o instanceof BigInteger) {
                    pb = (BigInteger)o;
                } else {
                    if (!(o instanceof Double)) throw new IllegalArgumentException();
                    pd = (Double)o;
                }
                ++n2;
            }
            return Boolean.TRUE;
        }
    };
    static final Appliable EQN = new Appliable(){

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public Object apply(Callback b, Object ... args) {
            Integer pi = null;
            BigInteger pb = null;
            Double pd = null;
            Number pn = null;
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                block23: {
                    Object o = objectArray[n2];
                    if (o instanceof Double) {
                        if (pn.doubleValue() != ((Number)o).doubleValue()) {
                            return Boolean.FALSE;
                        }
                    } else {
                        if (pi != null) {
                            if (o instanceof Integer) {
                                if (pi.compareTo((Integer)o) != 0) {
                                    return Boolean.FALSE;
                                }
                                break block23;
                            } else {
                                if (o instanceof BigInteger) {
                                    return Boolean.FALSE;
                                }
                                throw new IllegalArgumentException();
                            }
                        }
                        if (pb != null) {
                            if (o instanceof Integer) {
                                return Boolean.FALSE;
                            }
                            if (!(o instanceof BigInteger)) {
                                throw new IllegalArgumentException();
                            }
                            if (pb.compareTo((BigInteger)o) != 0) {
                                return Boolean.FALSE;
                            }
                        } else if (pd != null) {
                            double d = pd;
                            if (!(o instanceof Number)) {
                                throw new IllegalArgumentException();
                            }
                            if (d != ((Number)o).doubleValue()) {
                                return Boolean.FALSE;
                            }
                        } else {
                            if (o instanceof Integer) {
                                pi = (Integer)o;
                            } else if (o instanceof BigInteger) {
                                pb = (BigInteger)o;
                            } else {
                                if (!(o instanceof Double)) {
                                    throw new IllegalArgumentException();
                                }
                                pd = (Double)o;
                            }
                            pn = (Number)o;
                        }
                    }
                }
                ++n2;
            }
            return Boolean.TRUE;
        }
    };
    static final Appliable PLUS = new Appliable(){

        @Override
        public Object apply(Callback b, Object ... args) {
            BigInteger pb = null;
            Object pd = null;
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                BigInteger a;
                Object o = objectArray[n2];
                if (pb != null) {
                    a = LispAtto.toBigInteger(o);
                    if (a != null) {
                        pb = pb.add(a);
                    } else {
                        pd = pb.doubleValue() + ((Number)o).doubleValue();
                        pb = null;
                    }
                } else if (pd != null) {
                    a = LispAtto.toBigInteger(o);
                    pd = a != null ? Double.valueOf((Double)pd + a.doubleValue()) : Double.valueOf((Double)pd + ((Number)o).doubleValue());
                } else {
                    a = LispAtto.toBigInteger(o);
                    if (a != null) {
                        pb = a;
                    } else {
                        pd = (Double)o;
                    }
                }
                ++n2;
            }
            return pd != null ? pd : (pb != null ? LispAtto.toObject(pb) : new Integer(0));
        }
    };
    static final Appliable MINUS = new Appliable(){

        @Override
        public Object apply(Callback b, Object ... args) {
            BigInteger pb = null;
            Double pd = null;
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                BigInteger a;
                Object o = objectArray[n2];
                if (pb != null) {
                    a = LispAtto.toBigInteger(o);
                    if (a != null) {
                        pb = pb.subtract(a);
                    } else {
                        pd = pb.doubleValue() - ((Number)o).doubleValue();
                        pb = null;
                    }
                } else if (pd != null) {
                    a = LispAtto.toBigInteger(o);
                    pd = a != null ? Double.valueOf(pd - a.doubleValue()) : Double.valueOf(pd - ((Number)o).doubleValue());
                } else {
                    a = LispAtto.toBigInteger(o);
                    if (a != null) {
                        pb = a;
                    } else {
                        pd = (Double)o;
                    }
                }
                ++n2;
            }
            if (args.length != 1) {
                return pd != null ? pd : (pb != null ? LispAtto.toObject(pb) : new Integer(0));
            }
            if (pd != null) {
                return -pd.doubleValue();
            }
            return LispAtto.toObject(pb.negate());
        }
    };
    static final Appliable MUL = new Appliable(){

        @Override
        public Object apply(Callback b, Object ... args) {
            BigInteger pb = null;
            Object pd = null;
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                BigInteger a;
                Object o = objectArray[n2];
                if (pb != null) {
                    a = LispAtto.toBigInteger(o);
                    if (a != null) {
                        pb = pb.multiply(a);
                    } else {
                        pd = pb.doubleValue() * ((Number)o).doubleValue();
                        pb = null;
                    }
                } else if (pd != null) {
                    a = LispAtto.toBigInteger(o);
                    pd = a != null ? Double.valueOf((Double)pd * a.doubleValue()) : Double.valueOf((Double)pd * ((Number)o).doubleValue());
                } else {
                    a = LispAtto.toBigInteger(o);
                    if (a != null) {
                        pb = a;
                    } else {
                        pd = (Double)o;
                    }
                }
                ++n2;
            }
            return pd != null ? pd : (pb != null ? LispAtto.toObject(pb) : new Integer(1));
        }
    };
    static final Appliable DIV = new Appliable(){

        @Override
        public Object apply(Callback b, Object ... args) {
            BigInteger pb = null;
            Double pd = null;
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                BigInteger a;
                Object o = objectArray[n2];
                if (pb != null) {
                    a = LispAtto.toBigInteger(o);
                    if (a != null) {
                        pb = pb.divide(a);
                    } else {
                        pd = pb.doubleValue() / ((Number)o).doubleValue();
                        pb = null;
                    }
                } else if (pd != null) {
                    a = LispAtto.toBigInteger(o);
                    pd = a != null ? Double.valueOf(pd / a.doubleValue()) : Double.valueOf(pd / ((Number)o).doubleValue());
                } else {
                    a = LispAtto.toBigInteger(o);
                    if (a != null) {
                        pb = a;
                    } else {
                        pd = (Double)o;
                    }
                }
                ++n2;
            }
            if (args.length != 1) {
                return pd != null ? pd : (pb != null ? LispAtto.toObject(pb) : new Integer(0));
            }
            if (pd != null) {
                return 1.0 / pd;
            }
            return 1.0 / pb.doubleValue();
        }
    };
    static final Appliable STRING = new Appliable(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length == 1) {
                return new Boolean(args[0] instanceof String);
            }
            throw new IllegalArgumentException();
        }
    };
    static final Appliable SUBSTRING = new Appliable(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length != 3) {
                throw new IllegalArgumentException();
            }
            if (args[1] instanceof Integer && args[2] instanceof Integer) {
                return args[0].toString().substring((Integer)args[1], (Integer)args[2]);
            }
            throw new IllegalArgumentException();
        }
    };
    static final Appliable STRING_REF = new Appliable(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length != 2) {
                throw new IllegalArgumentException();
            }
            if (args[1] instanceof Integer) {
                return new Character(args[0].toString().charAt((Integer)args[1]));
            }
            throw new IllegalArgumentException();
        }
    };
    static final Appliable STRING_LENGTH = new Appliable(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length != 1) {
                throw new IllegalArgumentException();
            }
            if (args[0] instanceof String) {
                return new Integer(args[0].toString().length());
            }
            throw new IllegalArgumentException();
        }
    };
    static final Appliable STRING_APPEND = new Appliable(){

        @Override
        public Object apply(Callback b, Object ... args) {
            StringBuffer a = new StringBuffer();
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                a.append(o.toString());
                ++n2;
            }
            return a.toString();
        }
    };
    static final Appliable STRING_SYMBOL = new Appliable(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length == 1) {
                return Symbol.get(args[0].toString());
            }
            throw new IllegalArgumentException();
        }
    };
    static final Appliable SYMBOL_STRING = new Appliable(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length != 1) {
                throw new IllegalArgumentException();
            }
            if (args[0] instanceof Symbol) {
                return ((Symbol)args[0]).getName();
            }
            throw new IllegalArgumentException();
        }
    };
    static final Appliable VECTOR = new Appliable(){

        @Override
        public Object apply(Callback b, Object ... args) {
            if (args.length == 1) {
                return new Boolean(args[0] instanceof List);
            }
            throw new IllegalArgumentException();
        }
    };

    @Override
    public void init(Environment env) {
        env.binds.put(Symbol.get("cons"), CONS);
        env.binds.put(Symbol.get("eq?"), EQ);
        env.binds.put(Symbol.get("car"), CAR);
        env.binds.put(Symbol.get("cdr"), CDR);
        env.binds.put(Symbol.get("atom?"), ATOM);
        env.binds.put(Symbol.get("null?"), NULL);
        env.binds.put(Symbol.get("symbol?"), SYMBOL);
        env.binds.put(Symbol.get("error"), ERROR);
        env.binds.put(Symbol.get("eqv?"), EQV);
        env.binds.put(Symbol.get("set-car!"), SET_CAR);
        env.binds.put(Symbol.get("set-cdr!"), SET_CDR);
        env.binds.put(Symbol.get("apply"), APPLY);
        env.binds.put(Symbol.get("1+"), INC);
        env.binds.put(Symbol.get("1-"), DEC);
        env.binds.put(Symbol.get(">"), GT);
        env.binds.put(Symbol.get("<"), LT);
        env.binds.put(Symbol.get("="), EQN);
        env.binds.put(Symbol.get("+"), PLUS);
        env.binds.put(Symbol.get("-"), MINUS);
        env.binds.put(Symbol.get("*"), MUL);
        env.binds.put(Symbol.get("/"), DIV);
        env.binds.put(Symbol.get("string?"), STRING);
        env.binds.put(Symbol.get("substring"), SUBSTRING);
        env.binds.put(Symbol.get("string-ref"), STRING_REF);
        env.binds.put(Symbol.get("string-length"), STRING_LENGTH);
        env.binds.put(Symbol.get("string-append"), STRING_APPEND);
        env.binds.put(Symbol.get("string->symbol"), STRING_SYMBOL);
        env.binds.put(Symbol.get("symbol->string"), SYMBOL_STRING);
        env.binds.put(Symbol.get("vector?"), VECTOR);
    }

    @Override
    public Object apply(Environment v, Object f, Object ... args) {
        if (f instanceof Appliable) {
            return ((Appliable)f).apply(this, args);
        }
        throw new IllegalArgumentException(f.toString());
    }

    @Override
    public Object doIf(Environment v, Object cond, Object dotrue) {
        return cond.equals(Boolean.FALSE) ? LispAtto.UNDEF : LispAtto.traverse(this, v, dotrue);
    }

    @Override
    public Object doIf(Environment v, Object cond, Object dotrue, Object dofalse) {
        return cond.equals(Boolean.FALSE) ? LispAtto.traverse(this, v, dofalse) : LispAtto.traverse(this, v, dotrue);
    }

    @Override
    public Object doDefine(Environment v, Object sym, Object tobound) {
        if (sym instanceof Symbol) {
            v.binds.put((Symbol)sym, LispAtto.traverse(this, v, tobound));
            return LispAtto.UNDEF;
        }
        throw new IllegalArgumentException(sym.toString());
    }

    @Override
    public Object doLambda(Environment v, Object args, Object ... body) {
        return new Closure(v, args, body);
    }

    @Override
    public Object doSet(Environment v, Object sym, Object toset) {
        if (sym instanceof Symbol) {
            if (!v.set((Symbol)sym, LispAtto.traverse(this, v, toset))) {
                throw new IllegalArgumentException();
            }
            return LispAtto.UNDEF;
        }
        throw new IllegalArgumentException(sym.toString());
    }

    @Override
    public Object doBegin(Environment v, Object ... body) {
        Object r = LispAtto.UNDEF;
        Object[] objectArray = body;
        int n = body.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            r = LispAtto.traverse(this, v, o);
            ++n2;
        }
        return r;
    }
}

