/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.atto;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import net.morilib.lisp.atto.AttoParser;
import net.morilib.lisp.atto.Callback;
import net.morilib.lisp.atto.Cell;
import net.morilib.lisp.atto.Environment;
import net.morilib.lisp.atto.SimpleEngine;
import net.morilib.lisp.atto.Symbol;

public class LispAtto {
    public static final Object UNDEF = new Serializable(){

        public String toString() {
            return "#<undef>";
        }
    };
    static final BigInteger MAXINT = BigInteger.valueOf(Integer.MAX_VALUE);
    static final BigInteger MININT = BigInteger.valueOf(Integer.MIN_VALUE);
    Environment macroenv;
    Environment env;

    public LispAtto() {
        try {
            this.macroenv = new Environment();
            SimpleEngine.INSTANCE.init(this.macroenv);
            LispAtto.eval((Callback)SimpleEngine.INSTANCE, this.macroenv, LispAtto.class.getResourceAsStream("macro-atto.scm"));
            this.env = new Environment();
            SimpleEngine.INSTANCE.init(this.env);
            this.eval(LispAtto.class.getResourceAsStream("lib.scm"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static BigInteger toBigInteger(Object o) {
        if (o instanceof Integer) {
            return BigInteger.valueOf(((Integer)o).intValue());
        }
        if (o instanceof BigInteger) {
            return (BigInteger)o;
        }
        if (o instanceof Double) {
            return null;
        }
        throw new IllegalArgumentException();
    }

    static Object toObject(BigInteger x) {
        if (x.compareTo(MAXINT) > 0 || x.compareTo(MININT) < 0) {
            return x;
        }
        return x.intValue();
    }

    public static Object[] toArray(Object o) {
        if (!(o instanceof Cell)) {
            throw new IllegalArgumentException();
        }
        ArrayList<Object> l = new ArrayList<Object>();
        Cell c = (Cell)o;
        while (c != Cell.NIL) {
            l.add(c.car);
            if (!(c.cdr instanceof Cell)) {
                throw new IllegalArgumentException();
            }
            c = (Cell)c.cdr;
        }
        return l.toArray(new Object[0]);
    }

    public static Cell toList(Object ... objs) {
        Cell l = null;
        Cell r = Cell.NIL;
        if (objs.length > 0) {
            Object[] objectArray = objs;
            int n = objs.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (l != null) {
                    Cell a = new Cell(o, null);
                    l.cdr = a;
                    l = a;
                } else {
                    r = l = new Cell(o, null);
                }
                ++n2;
            }
            l.cdr = Cell.NIL;
        }
        return r;
    }

    public static Object traverse(Callback b, Environment v, Object o) {
        if (o instanceof Symbol) {
            Object p = v.find(o);
            if (p == null) {
                throw new IllegalArgumentException("unbound symbol: " + o);
            }
            return p;
        }
        if (!(o instanceof Cell) || o == Cell.NIL) {
            return o;
        }
        Object[] a = LispAtto.toArray(o);
        if (a[0] == Symbol.IF) {
            if (a.length == 3) {
                return b.doIf(v, LispAtto.traverse(b, v, a[1]), a[2]);
            }
            if (a.length == 4) {
                return b.doIf(v, LispAtto.traverse(b, v, a[1]), a[2], a[3]);
            }
            throw new IllegalArgumentException();
        }
        if (a[0] == Symbol.LAMBDA) {
            Object[] z = new Object[a.length - 2];
            int k = 2;
            while (k < a.length) {
                z[k - 2] = a[k];
                ++k;
            }
            return b.doLambda(v, a[1], z);
        }
        if (a[0] == Symbol.QUOTE) {
            if (a.length == 2) {
                return a[1];
            }
            throw new IllegalArgumentException();
        }
        if (a[0] == Symbol.BEGIN) {
            Object[] z = new Object[a.length - 1];
            int k = 1;
            while (k < a.length) {
                z[k - 1] = a[k];
                ++k;
            }
            return b.doBegin(v, z);
        }
        if (a[0] == Symbol.DEFINE) {
            if (a.length == 3) {
                return b.doDefine(v, a[1], a[2]);
            }
            throw new IllegalArgumentException();
        }
        if (a[0] == Symbol.SET) {
            if (a.length == 3) {
                return b.doSet(v, a[1], a[2]);
            }
            throw new IllegalArgumentException();
        }
        Object[] z = new Object[a.length - 1];
        int k = 1;
        while (k < a.length) {
            z[k - 1] = LispAtto.traverse(b, v, a[k]);
            ++k;
        }
        return b.apply(v, LispAtto.traverse(b, v, a[0]), z);
    }

    public static Object eval(Callback b, Environment v, Reader rd) throws IOException {
        Object o;
        Object p = null;
        b.init(v);
        while ((o = AttoParser.read(rd)) != null) {
            p = LispAtto.traverse(b, v, o);
        }
        return p;
    }

    public static Object eval(Callback b, Environment v, InputStream ins) throws IOException {
        return LispAtto.eval(b, v, new InputStreamReader(ins));
    }

    public Object eval(Object p) {
        Object o = p;
        o = new Cell(Symbol.get("eval-macro"), new Cell(new Cell(Symbol.QUOTE, new Cell(o, Cell.NIL)), Cell.NIL));
        o = LispAtto.traverse(SimpleEngine.INSTANCE, this.macroenv, o);
        o = LispAtto.traverse(SimpleEngine.INSTANCE, this.env, o);
        return o;
    }

    public Object eval(Reader rd) throws IOException {
        Object p = UNDEF;
        Object o;
        while ((o = AttoParser.read(rd)) != null) {
            p = this.eval(o);
        }
        return p;
    }

    public Object eval(InputStream in) throws IOException {
        return this.eval(new InputStreamReader(in));
    }

    public static void main(String[] args) {
        LispAtto s = new LispAtto();
        Object p = UNDEF;
        InputStreamReader rd = new InputStreamReader(System.in);
        System.out.print(" >");
        while (true) {
            try {
                while (true) {
                    Object o;
                    if ((o = AttoParser.read(rd)) == null) {
                        System.exit(0);
                    } else {
                        if (o == AttoParser.INVALIDTOKEN) continue;
                        p = s.eval(o);
                        System.out.println(p);
                    }
                    System.out.print(" >");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (ArithmeticException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

