/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano.subr;

import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.Environment;
import net.morilib.lisp.nano.LispComplex;
import net.morilib.lisp.nano.LispDouble;
import net.morilib.lisp.nano.LispMessage;
import net.morilib.lisp.nano.subr.UnaryArgs;

public class Angle
extends UnaryArgs {
    @Override
    protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
        if (c1a instanceof LispComplex) {
            LispComplex n = (LispComplex)c1a;
            if (n.isNaN()) {
                return LispDouble.NaN;
            }
            if (n.isReal()) {
                double r = n.getRealDouble();
                if (r >= 0.0) {
                    return LispDouble.ZERO;
                }
                return new LispDouble(Math.PI);
            }
            return n.angle();
        }
        throw mesg.getError("err.require.complex", c1a);
    }
}

