/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.automata.lr;

import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.automata.cfg.LispCFGRule;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/01/20
 */
public class LispShiftReduceConflict extends Datum2 {

	//
	private Datum shift;
	private Datum state;
	private LispCFGRule reduce;

	/**
	 * 
	 * @param state
	 * @param shift
	 * @param reduce
	 */
	public LispShiftReduceConflict(Datum state, Datum shift,
			LispCFGRule reduce) {
		this.state  = state;
		this.shift  = shift;
		this.reduce = reduce;
	}

	/**
	 * @return the shift
	 */
	public Datum getShift() {
		return shift;
	}

	/**
	 * @return the state
	 */
	public Datum getState() {
		return state;
	}

	/**
	 * @return the reduce
	 */
	public LispCFGRule getReduce() {
		return reduce;
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.Datum2#toDisplayString(java.lang.StringBuilder)
	 */
	@Override
	public void toDisplayString(StringBuilder buf) {
		buf.append("#<shift-reduce-conflict ");
		buf.append("shift ").append(shift).append(" vs ");
		buf.append("reduce ").append(reduce).append(">");
	}

}
