/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.automata.dfa;

import java.util.ArrayList;
import java.util.Set;

import net.morilib.automata.DFAState;
import net.morilib.automata.dfa.DFAs;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.MultiValues;
import net.morilib.lisp.subr.BinaryArgs;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/01/05
 */
public class MatchMooreMachine extends BinaryArgs {

	/* (non-Javadoc)
	 * @see net.morilib.lisp.subr.BinaryArgs#execute(net.morilib.lisp.Datum, net.morilib.lisp.Datum, net.morilib.lisp.Environment, net.morilib.lisp.LispMessage)
	 */
	@Override
	protected Datum execute(Datum c1a, Datum c2a, Environment env,
			LispMessage mesg) {
		ConsIterator itr = new ConsIterator(c2a);
		DFAState<Datum, Datum, ?> st;
		Set<Datum> r;

		if(c1a instanceof ILispMooreMachine) {
			st = ((ILispMooreMachine)c1a).getDFA().getInitialState();
			r  = DFAs.matchAll(st, itr);
			if(r.isEmpty()) {
				return LispBoolean.FALSE;
			} else {
				return MultiValues.newValues(new ArrayList<Datum>(r));
			}
		} else {
			throw mesg.getError("err.automata.require.mooremachine",
					c1a);
		}
	}

}
