/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.math.special;

import net.morilib.lang.number.complex.ComplexDouble;
import net.morilib.lang.number.complex.RectanglarComplexDouble;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispComplex;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.math.special.CylinderFunctions;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2010/12/04
 */
public class BesselJ extends BinaryArgs {

	/* (non-Javadoc)
	 * @see net.morilib.lisp.subr.BinaryArgs#execute(net.morilib.lisp.Datum, net.morilib.lisp.Datum, net.morilib.lisp.Environment, net.morilib.lisp.LispMessage)
	 */
	@Override
	protected Datum execute(
			Datum c1a, Datum c2a, Environment env,
			LispMessage mesg) {
		if(!(c1a instanceof LispComplex)) {
			throw mesg.getError("err.require.complex", c1a);
		} else if(!(c2a instanceof LispComplex)) {
			throw mesg.getError("err.require.complex", c2a);
		} else if(!((LispComplex)c2a).isReal()) {
			throw mesg.getError("err.require.real", c2a);
		}

		LispComplex z0 = (LispComplex)c1a;
		double nu = c2a.getRealDouble();
		ComplexDouble z;
		LispComplex res;

		if(z0.isReal()) {
			double r;
			
			r = CylinderFunctions.J(z0.getRealDouble(), nu);
			res = new LispDouble(r);
		} else {
			ComplexDouble r;
			
			z = RectanglarComplexDouble.valueOf(
					z0.getRealDouble(), z0.getImagDouble());
			r = CylinderFunctions.J(z, nu);
			res = LispComplex.newComplex(
					r.realPart(), r.imagPart());
		}
		return res;
	}

}
