/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.nio;

import java.nio.ReadOnlyBufferException;

import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispEndianness;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Undef;
import net.morilib.lisp.subr.QuaternaryArgs;
import net.morilib.lisp.subr.SubrUtils;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2011/06/11
 */
public class BlobS32SetS extends QuaternaryArgs {

	//
	private static int getNumber(Datum d, LispMessage mesg) {
		if(!(d instanceof LispInteger)) {
			throw mesg.getError("err.require.real", d);
		} else if(((LispInteger)d).inIntRange()) {
			return (int)d.getInt();
		} else {
			throw mesg.getError("err.uvector.outofrange.s8", d);
		}
	}

	/* (non-Javadoc)
	 * @see net.morilib.lisp.subr.BinaryArgs#execute(net.morilib.lisp.Datum, net.morilib.lisp.Datum, net.morilib.lisp.Environment, net.morilib.lisp.LispMessage)
	 */
	@Override
	protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Datum c4a,
			Environment env, LispMessage mesg) {
		if(!(c1a instanceof LispEndianness.Endian)) {
			throw mesg.getError("err.srfi74.require.endianness", c1a);
		} else if(c2a instanceof LispBlob) {
			int k = SubrUtils.getSmallIntegerExact(c3a, mesg);

			try {
				((LispBlob)c2a).order((LispEndianness.Endian)c2a);
				((LispBlob)c2a).putInt(k, getNumber(c4a, mesg));
				return Undef.UNDEF;
			} catch(IndexOutOfBoundsException e) {
				throw mesg.getError("err.srfi74.blob.outofrange",
						"" + k);
			} catch(ReadOnlyBufferException e) {
				throw mesg.getError("err.srfi74.buffer.readonly");
			}
		} else {
			throw mesg.getError("err.srfi74.require.blob", c1a);
		}
	}

}
