/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

import net.morilib.lisp.CompiledCode.Builder;
import net.morilib.lisp.LispCompiler.MiscInfo;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2011/06/11
 */
public class LispFeature {

	//
	private static class _AddFeature extends BinaryArgs {

		/* (non-Javadoc)
		 * @see net.morilib.lisp.subr.UnaryArgs#execute(net.morilib.lisp.Datum, net.morilib.lisp.Environment, net.morilib.lisp.LispMessage)
		 */
		@Override
		protected Datum execute(Datum c1a, Datum c2a, Environment env,
				LispMessage mesg) {
			features.put(c1a, ((Closure)c2a).getCode());
			return Undef.UNDEF;
		}

	}

	/**
	 * 
	 *
	 *
	 * @author MORIGUCHI, Yuichiro 2011/06/11
	 */
	public static class SynDefineFeature extends Syntax {

		/* (non-Javadoc)
		 * @see net.morilib.lisp.Syntax#compile(net.morilib.lisp.Datum, net.morilib.lisp.Environment, net.morilib.lisp.LispCompiler, net.morilib.lisp.CompiledCode.Builder, boolean, net.morilib.lisp.Cons, boolean, net.morilib.lisp.LispMessage, java.util.List, net.morilib.lisp.CodeExecutor, net.morilib.lisp.IntStack, net.morilib.lisp.LispCompiler.MiscInfo)
		 */
		@Override
		/*package*/ void compile(Datum body, Environment env,
				LispCompiler comp, Builder build, boolean toplevel,
				Cons callsym, boolean istail, LispMessage mesg,
				List<Cons> symlist, CodeExecutor exec,
				IntStack memento, MiscInfo syncased) {
			CompiledCode.Builder nbuild = new CompiledCode.Builder();
			Environment  nenv = new Environment(env);
			ClosureClass cl = new ClosureClass();
			ConsIterator itr = new ConsIterator(body);
			Datum sym = SubrUtils.nextIf(itr, mesg, body);

			if(!toplevel) {
				throw mesg.getError("err.nottoplevel");
			} else if(!(sym instanceof Symbol)) {
				throw mesg.getError("err.require.symbol", sym);
			}

			SyntaxUtils.compileList(
					itr.rest(), nenv, comp, nbuild, callsym, false,
					mesg, symlist, exec, memento, syncased);
			cl.setParameterList(Nil.NIL);
			cl.setCode(nbuild.getCodeRef());
			build.addPush(_ADD_FEATURE);
			build.addBeginList();
			build.addPush(sym);
			build.addAppendList();
			build.addPush(cl);
			build.addAppendList();
			build.addEndList();
			build.addCall();
		}

		/* (non-Javadoc)
		 * @see net.morilib.lisp.Syntax#replaceLocalVals(net.morilib.lisp.Datum, net.morilib.lisp.Environment, net.morilib.lisp.LispCompiler, net.morilib.lisp.Environment, net.morilib.lisp.LispMessage, boolean, int)
		 */
		@Override
		Datum replaceLocalVals(Datum body, Environment env,
				LispCompiler comp, Environment ienv, LispMessage mesg,
				boolean toplv, int ttype) {
			throw mesg.getError("err.define.definesyntax");
		}

	}

	/**
	 * 
	 *
	 *
	 * @author MORIGUCHI, Yuichiro 2011/06/11
	 */
	public static class IsFeatureExist extends UnaryArgs {

		/* (non-Javadoc)
		 * @see net.morilib.lisp.subr.UnaryArgs#execute(net.morilib.lisp.Datum, net.morilib.lisp.Environment, net.morilib.lisp.LispMessage)
		 */
		@Override
		protected Datum execute(Datum c1a, Environment env,
				LispMessage mesg) {
			return LispBoolean.getInstance(features.containsKey(c1a));
		}

	}

	/**
	 * 
	 *
	 *
	 * @author MORIGUCHI, Yuichiro 2011/06/11
	 */
	public static class ApplyFeature extends UnaryArgs {

		/* (non-Javadoc)
		 * @see net.morilib.lisp.subr.UnaryArgs#execute(net.morilib.lisp.Datum, net.morilib.lisp.Environment, net.morilib.lisp.LispMessage)
		 */
		@Override
		protected Datum execute(Datum c1a, Environment env,
				LispMessage mesg) {
			CompiledCode cd = features.get(c1a);

			if(cd != null) {
				CodeExecutor exe =
					CodeExecutorFactory.getInstance(mesg);

				exe.exec(cd, env, exe.newMemento());
				return LispBoolean.TRUE;
			} else {
				return LispBoolean.FALSE;
			}
		}

	}

	//
	private static final BinaryArgs _ADD_FEATURE = new _AddFeature();

	//
	private static ConcurrentHashMap<Datum, CompiledCode> features =
		new ConcurrentHashMap<Datum, CompiledCode>();

}
